/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.git;

import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflows.work.WorkContext;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public abstract class GitUtils {
    private GitUtils() {
    }

    public static String getRepoPath(WorkContext workContext) {
        Object dest = workContext.get("gitDestination");
        if (dest == null) {
            return WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"path", (String)"");
        }
        return WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"path", (String)dest.toString());
    }

    public static Repository getRepo(String path) throws IOException {
        Path gitDir = Paths.get(path, new String[0]).resolve(".git/");
        return ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir.toFile())).build();
    }
}

