/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.git;

import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitCloneTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitCloneTask.class);

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("uri").type(WorkParameterType.TEXT).optional(false).description("Url to clone from").build(), WorkParameter.builder().key("branch").type(WorkParameterType.TEXT).optional(true).description("Branch to clone from, default main").build(), WorkParameter.builder().key("credentials").type(WorkParameterType.TEXT).optional(false).description("Git credential").build());
    }

    public WorkReport execute(WorkContext workContext) {
        String gitUri = null;
        String destination = null;
        String gitBranch = null;
        try {
            gitUri = this.getRequiredParameterValue("uri");
            gitBranch = this.getOptionalParameterValue("branch", "main");
            destination = this.cloneRepo(gitUri, gitBranch);
        }
        catch (MissingParameterException e) {
            log.debug("Failed to resolve required parameter: {}", (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        catch (TransportException e) {
            log.debug("Cannot connect to repository server '{}' error: {}", (Object)gitUri, (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new Exception("cannot connect to the repository server"));
        }
        catch (InvalidRemoteException e) {
            log.debug("remote repository server '{}' is not available, error: {}", (Object)gitUri, (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new Exception("Remote repository " + gitUri + " is not available"));
        }
        catch (IOException | GitAPIException e) {
            log.debug("Cannot clone repository: {} {}", (Object)gitUri, (Object)e.getMessage());
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new Exception("cannot clone repository, error: " + e.getMessage()));
        }
        workContext.put("gitUri", (Object)gitUri);
        workContext.put("gitDestination", (Object)destination);
        workContext.put("gitBranch", (Object)gitBranch);
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext, null);
    }

    private String cloneRepo(String gitUri, String gitBranch) throws InvalidRemoteException, TransportException, IOException, GitAPIException {
        String tmpDir = Files.createTempDirectory("GitTaskClone", new FileAttribute[0]).toAbsolutePath().toString();
        Git.cloneRepository().setURI(gitUri).setBranch("refs/heads/" + gitBranch).setDirectory(new File(tmpDir)).call();
        return tmpDir;
    }

    @Generated
    public GitCloneTask() {
    }
}

