/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.git;

import com.google.common.base.Strings;
import com.redhat.parodos.tasks.git.GitUtils;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitBranchTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitBranchTask.class);

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("path").type(WorkParameterType.TEXT).optional(true).description("path where the git repo is located").build(), WorkParameter.builder().key("branch").type(WorkParameterType.TEXT).optional(false).description("branch whichs need to be created").build());
    }

    public String getRepoPath(WorkContext workContext) {
        return GitUtils.getRepoPath(workContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkReport execute(WorkContext workContext) {
        String branchName = null;
        try {
            branchName = this.getRequiredParameterValue("branch");
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        String path = this.getRepoPath(workContext);
        if (Strings.isNullOrEmpty((String)path)) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("The path parameter cannot be null or empty"));
        }
        try (Repository repo = this.getRepo(path);){
            Git git = new Git(repo);
            Ref branchRef = repo.findRef(branchName);
            if (branchRef != null) {
                DefaultWorkReport defaultWorkReport = new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("Branch '%s' is already created".formatted(branchName)));
                return defaultWorkReport;
            }
            git.branchCreate().setName(branchName).call();
            git.checkout().setName(branchName).call();
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext, null);
        }
        catch (FileNotFoundException | GitAPIException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Cannot create the branch for the repository: %s".formatted(e.getMessage()), e));
        }
        catch (IOException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("No repository at '%s' error: %s".formatted(path, e.getMessage()), e));
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new RuntimeException("Cannot create the branch on the repository: %s".formatted(e.getMessage()), e));
        }
    }

    private Repository getRepo(String path) throws IOException {
        return GitUtils.getRepo(path);
    }

    @Generated
    public GitBranchTask() {
    }
}

