/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.git;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.redhat.parodos.tasks.git.GitUtils;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.archive.ZipFormat;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitArchiveTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GitArchiveTask.class);

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("path").type(WorkParameterType.TEXT).optional(true).description("path where the git repo is located").build());
    }

    public String getRepoPath(WorkContext workContext) {
        return GitUtils.getRepoPath(workContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkReport execute(WorkContext workContext) {
        String path = this.getRepoPath(workContext);
        if (Strings.isNullOrEmpty((String)path)) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)new IllegalArgumentException("The path parameter cannot be null or empty"));
        }
        try (Repository repo = null;){
            repo = this.getRepo(path);
            Path archivePath = this.archive(repo);
            workContext.put("gitArchivePath", (Object)archivePath.toAbsolutePath().toString());
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext, null);
    }

    private Repository getRepo(String path) throws IOException {
        return GitUtils.getRepo(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path archive(Repository repo) throws FileNotFoundException, IOException, GitAPIException {
        Git git = new Git(repo);
        ArchiveCommand.registerFormat((String)"zip", (ArchiveCommand.Format)new ZipFormat());
        String tmpdir = Files.createTempDir().getAbsolutePath();
        Path zipFile = Paths.get(tmpdir + "/output.zip", new String[0]);
        try (FileOutputStream out = new FileOutputStream(zipFile.toAbsolutePath().toString());){
            git.archive().setTree(repo.resolve("HEAD")).setPrefix("src/").setFormat("zip").setOutputStream((OutputStream)out).call();
        }
        finally {
            git.close();
        }
        return zipFile;
    }

    @Generated
    public GitArchiveTask() {
    }
}

