/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.migrationtoolkit;

import com.redhat.parodos.tasks.migrationtoolkit.App;
import com.redhat.parodos.tasks.migrationtoolkit.MTAApplicationClient;
import com.redhat.parodos.tasks.migrationtoolkit.MTAClient;
import com.redhat.parodos.tasks.migrationtoolkit.Result;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetApplicationTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetApplicationTask.class);
    protected MTAApplicationClient mtaClient;

    public GetApplicationTask() {
    }

    public GetApplicationTask(URI serverURL, String bearerToken) {
        this.mtaClient = new MTAClient(serverURL, bearerToken);
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("serverURL").type(WorkParameterType.TEXT).optional(true).description("Base URL of the MTA instance - e.g https://mta-openshift-mta.app.clustername.clusterdomain").build(), WorkParameter.builder().key("bearerToken").type(WorkParameterType.TEXT).optional(true).description("Bearer token to authenticate server requests").build(), WorkParameter.builder().key("applicationName").type(WorkParameterType.TEXT).optional(false).description("The application name as presented in the application hub. Can be generated from the repository name").build(), WorkParameter.builder().key("sourceRepository").type(WorkParameterType.TEXT).optional(true).description("The application name as presented in the application hub. Can be generated from the repository name").build());
    }

    public WorkReport execute(WorkContext workContext) {
        String applicationName = "";
        try {
            if (this.mtaClient == null) {
                String serverUrl = this.getOptionalParameterValue(workContext, "serverURL", null);
                String bearerToken = this.getOptionalParameterValue(workContext, "bearerToken", null);
                this.mtaClient = new MTAClient(URI.create(serverUrl), bearerToken);
            }
            applicationName = this.getRequiredParameterValue(workContext, "applicationName");
        }
        catch (MissingParameterException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
        Result<App> result = this.mtaClient.get(applicationName);
        if (result == null) {
            return new DefaultWorkReport(WorkStatus.FAILED, new WorkContext(), (Throwable)new IllegalStateException("MTA client returned empty result with no error"));
        }
        if (result instanceof Result.Failure) {
            Result.Failure failure = (Result.Failure)result;
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, failure.t());
        }
        if (result instanceof Result.Success) {
            Result.Success success = (Result.Success)result;
            this.addParameter(workContext, "applicationID", String.valueOf(((App)success.value()).id()));
            return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
        }
        throw new IllegalArgumentException();
    }
}

