/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.migrationtoolkit;

import com.redhat.parodos.email.Message;
import com.redhat.parodos.tasks.migrationtoolkit.MTAClient;
import com.redhat.parodos.tasks.migrationtoolkit.MTATaskGroupClient;
import com.redhat.parodos.tasks.migrationtoolkit.Result;
import com.redhat.parodos.tasks.migrationtoolkit.TaskGroup;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.infrastructure.BaseInfrastructureWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAnalysisTask
extends BaseInfrastructureWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetAnalysisTask.class);
    protected MTATaskGroupClient mtaClient;
    private URI serverUrl;
    private final Consumer<Message> messageConsumer;

    public GetAnalysisTask(URI serverURL, String bearerToken, Consumer<Message> messageConsumer) {
        this.serverUrl = serverURL;
        this.mtaClient = new MTAClient(serverURL, bearerToken);
        this.messageConsumer = messageConsumer;
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("taskGroupID").type(WorkParameterType.NUMBER).optional(false).description("The application name as presented in the application hub").build(), WorkParameter.builder().key("serverURL").type(WorkParameterType.TEXT).optional(true).description("Base URL of the MTA instance - e.g https://mta-openshift-mta.app.clustername.clusterdomain").build(), WorkParameter.builder().key("bearerToken").type(WorkParameterType.TEXT).optional(true).description("Bearer token to authenticate server requests").build());
    }

    public WorkReport execute(WorkContext workContext) {
        int taskGroupID;
        if (this.mtaClient == null) {
            this.serverUrl = URI.create(this.getOptionalParameterValue(workContext, "serverURL", null));
            String bearerToken = this.getOptionalParameterValue(workContext, "bearerToken", null);
            if (this.serverUrl == null) {
                log.error("serverURL is empty. Either pass it while creating the instance of the task or in the context");
                return new DefaultWorkReport(WorkStatus.FAILED, workContext);
            }
            this.mtaClient = new MTAClient(this.serverUrl, bearerToken);
        }
        try {
            taskGroupID = Integer.parseInt(this.getRequiredParameterValue(workContext, "taskGroupID"));
        }
        catch (MissingParameterException | NumberFormatException e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, e);
        }
        Result<TaskGroup> result = this.mtaClient.get(taskGroupID);
        if (result == null) {
            return new DefaultWorkReport(WorkStatus.FAILED, new WorkContext(), (Throwable)new IllegalStateException("MTA client returned empty result with no error."));
        }
        if (result instanceof Result.Failure) {
            Result.Failure failure = (Result.Failure)result;
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, failure.t());
        }
        if (result instanceof Result.Success) {
            Result.Success success = (Result.Success)result;
            if ("Ready".equals(((TaskGroup)success.value()).state()) && ((TaskGroup)success.value()).tasks() != null && ((TaskGroup)success.value()).tasks()[0].state().equals("Succeeded")) {
                String reportURL = String.format("%s/hub/applications/%d/bucket/%s", this.serverUrl, ((TaskGroup)success.value()).tasks()[0].application().id(), ((TaskGroup)success.value()).data().output());
                this.sendEmail(reportURL, this.getOptionalParameterValue(workContext, "email", null));
                this.addParameter(workContext, "reportURL", reportURL);
                return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
            }
            if ("Failed".equals(((TaskGroup)success.value()).state())) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext, new Throwable("The underlying task failed, the report will not be ready"));
            }
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, new Throwable("The report is not ready yet."));
        }
        throw new IllegalArgumentException();
    }

    private void sendEmail(String reportURL, String recipient) {
        if (recipient == null) {
            return;
        }
        this.messageConsumer.accept(new Message(recipient, "parodos-task-notificaion+mailtrap@redhat.com", "Parodos: Analysis report is done", String.format("The analysis report is done. Find it here %s", reportURL)));
    }
}

