/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.jira;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.redhat.parodos.tasks.jira.JiraIssue;
import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JiraTask.class);
    protected JiraIssueClient jiraClient;
    public static final int DEFAULT_EXECUTION_TIMEOUT_IN_SECONDS = 600;

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        return List.of(WorkParameter.builder().key("serverURL").type(WorkParameterType.TEXT).optional(false).description("Base URL of the Jira instance - e.g https://jira.example.org").build(), WorkParameter.builder().key("bearerToken").type(WorkParameterType.TEXT).optional(false).description("Bearer token to authenticate Jira server requests").build());
    }

    public WorkReport execute(WorkContext workContext) {
        if (this.jiraClient == null) {
            try {
                String serverUrl = WorkContextDelegate.getRequiredValueFromRequestParams((WorkContext)workContext, (String)"serverURL");
                String bearerToken = WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"bearerToken", null);
                this.jiraClient = new JiraClient(URI.create(serverUrl), bearerToken);
            }
            catch (MissingParameterException e) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
            }
        }
        String id = WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"id", (String)"");
        String summary = WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"summary", (String)"");
        String project = WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"project", (String)"");
        String status = WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"status", (String)"");
        String description = WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"description", (String)"");
        String comment = WorkContextDelegate.getOptionalValueFromRequestParams((WorkContext)workContext, (String)"comment", (String)"");
        if (id.isBlank()) {
            try {
                JiraIssue issue = this.createIssue(new JiraIssue("", project, summary, description, "", List.of(comment)));
                DefaultWorkReport report = new DefaultWorkReport(WorkStatus.COMPLETED, new WorkContext(), null);
                report.getWorkContext().put("issue", (Object)issue);
                return report;
            }
            catch (Exception e) {
                return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
            }
        }
        try {
            JiraIssue issue = this.getIssueByID(id);
            if (summary.isBlank() && description.isBlank() && comment.isBlank()) {
                WorkContext context = new WorkContext();
                context.put("issue", (Object)issue);
                return new DefaultWorkReport(WorkStatus.COMPLETED, context, null);
            }
            if (!summary.isBlank() && !issue.summary.equals(summary)) {
                issue.summary = summary;
            }
            if (!description.isBlank() && !issue.description.equals(description)) {
                issue.description = description;
            }
            if (!status.isBlank() && !issue.status.equals(status)) {
                issue.status = status;
            }
            this.updateIssue(issue);
            if (!comment.isBlank()) {
                this.jiraClient.addComment(id, comment);
            }
            WorkContext context = new WorkContext();
            context.put("issue", (Object)issue);
            return new DefaultWorkReport(WorkStatus.COMPLETED, context, null);
        }
        catch (Exception e) {
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, (Throwable)e);
        }
    }

    private JiraIssue createIssue(JiraIssue issue) throws Exception {
        try {
            JSONObject jsonObject = this.jiraClient.create(issue.project, issue.summary, issue.description);
            return new JiraIssue(jsonObject.getString("id"), null, null, null, null, null);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void updateIssue(JiraIssue issue) throws Exception {
        try {
            this.jiraClient.update(issue.id, issue.summary, issue.description, issue.status);
        }
        catch (JSONException e) {
            throw new Exception(e);
        }
    }

    private JiraIssue getIssueByID(String id) throws Exception {
        try {
            JSONObject o = this.jiraClient.get(id);
            return new JiraIssue(o.getString("id"), o.getString("project"), o.getString("summary"), o.getString("description"), o.getString("status"), Collections.emptyList());
        }
        catch (JSONException e) {
            throw new Exception(e);
        }
    }

    static interface JiraIssueClient {
        public JSONObject get(String var1) throws Exception;

        public void update(String var1, String var2, String var3, String var4) throws Exception;

        public void addComment(String var1, String var2) throws Exception;

        public JSONObject create(String var1, String var2, String var3) throws Exception;
    }

    static class JiraClient
    implements JiraIssueClient {
        private IssueRestClient restClient;

        private JiraClient(URI serverURI, String bearerToken) {
            this.restClient = new AsynchronousJiraRestClientFactory().create(serverURI, r -> r.setHeader("Authorization", bearerToken)).getIssueClient();
        }

        @Override
        public JSONObject get(String id) throws Exception {
            Issue issue;
            try {
                issue = (Issue)this.restClient.getIssue(id).get(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new Exception(e);
            }
            return new JSONObject().put("id", (Object)issue.getId()).put("summary", (Object)issue.getSummary()).put("description", (Object)issue.getDescription()).put("status", (Object)issue.getStatus()).put("comments", (Object)issue.getComments());
        }

        @Override
        public void update(String id, String summary, String description, String status) throws Exception {
            IssueInputBuilder issueInputBuilder = new IssueInputBuilder();
            if (description != null && !description.isBlank()) {
                issueInputBuilder.setDescription(description);
            }
            if (summary != null && !summary.isBlank()) {
                issueInputBuilder.setSummary(summary);
            }
            try {
                this.restClient.updateIssue(id, issueInputBuilder.build()).get(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new Exception(e);
            }
            try {
                Issue issue = (Issue)this.restClient.getIssue(id).get(600L, TimeUnit.SECONDS);
                Iterable transitions = (Iterable)this.restClient.getTransitions(issue).get(600L, TimeUnit.SECONDS);
                Optional<Transition> transition = StreamSupport.stream(transitions.spliterator(), false).filter(t -> t.getName().equals(status)).findFirst();
                if (transition.isPresent()) {
                    this.restClient.transition(issue, new TransitionInput(transition.get().getId())).get(600L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void addComment(String id, String comment) throws Exception {
            Issue issue;
            try {
                issue = (Issue)this.restClient.getIssue(id).get(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new Exception(e);
            }
            try {
                this.restClient.addComment(issue.getCommentsUri(), Comment.valueOf((String)comment)).get(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public JSONObject create(String project, String summary, String description) throws Exception {
            IssueInput input = new IssueInputBuilder().setSummary(summary).setProjectKey(project).setDescription(description).build();
            try {
                BasicIssue issue = (BasicIssue)this.restClient.createIssue(input).get(600L, TimeUnit.SECONDS);
                return new JSONObject().put("id", (Object)issue.getId());
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new Exception(e);
            }
        }
    }
}

