/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.tasks.kubeapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.redhat.parodos.tasks.kubeapi.KubernetesApi;
import com.redhat.parodos.tasks.kubeapi.KubernetesApiImpl;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.parameter.WorkParameterType;
import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.util.generic.dynamic.DynamicKubernetesObject;
import io.kubernetes.client.util.generic.dynamic.Dynamics;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeapiWorkFlowTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubeapiWorkFlowTask.class);
    private KubernetesApi api;

    public KubeapiWorkFlowTask() {
        this.api = new KubernetesApiImpl();
    }

    KubeapiWorkFlowTask(KubernetesApi api, String beanName) {
        this.api = api;
        this.setBeanName(beanName);
    }

    @NonNull
    public List<WorkParameter> getWorkFlowTaskParameters() {
        LinkedList<WorkParameter> params = new LinkedList<WorkParameter>();
        params.add(WorkParameter.builder().key("kubeconfig-json").type(WorkParameterType.TEXT).optional(false).description("kubeconfig in json format").build());
        params.add(WorkParameter.builder().key("api-group").type(WorkParameterType.TEXT).optional(false).description("API group of resource").build());
        params.add(WorkParameter.builder().key("api-version").type(WorkParameterType.TEXT).optional(false).description("API version of resource").build());
        params.add(WorkParameter.builder().key("kind-plural-name").type(WorkParameterType.TEXT).optional(false).description("Plural name of the resource kind. E.g. crontabs").build());
        params.add(WorkParameter.builder().key("operation").type(WorkParameterType.TEXT).optional(false).description("Operation type/name. Can be one of " + Arrays.toString((Object[])OperationType.values())).build());
        params.add(WorkParameter.builder().key("resource-json").type(WorkParameterType.TEXT).optional(true).description("The JSON to be used in create and update operations").build());
        params.add(WorkParameter.builder().key("resource-name").type(WorkParameterType.TEXT).optional(true).description("Name of resource for get operation").build());
        params.add(WorkParameter.builder().key("resource-namespace").type(WorkParameterType.TEXT).optional(true).description("Namespace of resource for get operation").build());
        params.add(WorkParameter.builder().key("work-ctx-key").type(WorkParameterType.TEXT).optional(true).description("In get operation the result is stored in WorkContext with the provided key").build());
        return params;
    }

    @NonNull
    public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return List.of(WorkFlowTaskOutput.OTHER);
    }

    public WorkReport execute(WorkContext workContext) {
        String operation = "";
        try {
            String kubeconfigJson = this.getRequiredParameterValue(workContext, "kubeconfig-json");
            String apiGroup = this.getRequiredParameterValue(workContext, "api-group");
            String apiVersion = this.getRequiredParameterValue(workContext, "api-version");
            String kindPluralName = this.getRequiredParameterValue(workContext, "kind-plural-name");
            operation = this.getRequiredParameterValue(workContext, "operation");
            String kubeconfig = new YAMLMapper().writeValueAsString((Object)new ObjectMapper().readTree(kubeconfigJson));
            OperationType operationType = OperationType.valueOf(operation.toUpperCase());
            switch (operationType) {
                case UPDATE: {
                    this.update(workContext, kubeconfig, apiGroup, apiVersion, kindPluralName);
                    break;
                }
                case CREATE: {
                    this.create(workContext, kubeconfig, apiGroup, apiVersion, kindPluralName);
                    break;
                }
                case GET: {
                    this.get(workContext, kubeconfig, apiGroup, apiVersion, kindPluralName);
                }
            }
        }
        catch (MissingParameterException | ApiException | IOException | IllegalArgumentException e) {
            log.error("Kubeapi task failed for operation " + operation, e);
            return new DefaultWorkReport(WorkStatus.FAILED, workContext, e);
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private void get(WorkContext ctx, String kubeconfig, String apiGroup, String apiVersion, String kindPluralName) throws MissingParameterException, ApiException, IOException {
        String resourceName = this.getRequiredParameterValue(ctx, "resource-name");
        String resourceNamespace = this.getRequiredParameterValue(ctx, "resource-namespace");
        String workCtxKey = this.getRequiredParameterValue(ctx, "work-ctx-key");
        DynamicKubernetesObject obj = this.api.get(kubeconfig, apiGroup, apiVersion, kindPluralName, resourceNamespace, resourceName);
        String resourceJson = obj.getRaw().toString();
        ctx.put(workCtxKey, (Object)resourceJson);
    }

    private void create(WorkContext ctx, String kubeconfig, String apiGroup, String apiVersion, String kindPluralName) throws MissingParameterException, ApiException, IOException {
        String resourceJson = this.getRequiredParameterValue(ctx, "resource-json");
        DynamicKubernetesObject obj = Dynamics.newFromJson((String)resourceJson);
        this.api.create(kubeconfig, apiGroup, apiVersion, kindPluralName, obj);
    }

    private void update(WorkContext ctx, String kubeconfig, String apiGroup, String apiVersion, String kindPluralName) throws MissingParameterException, ApiException, IOException {
        String resourceJson = this.getRequiredParameterValue(ctx, "resource-json");
        DynamicKubernetesObject newObj = Dynamics.newFromJson((String)resourceJson);
        String resourceNamespace = newObj.getMetadata().getNamespace();
        String resourceName = newObj.getMetadata().getName();
        DynamicKubernetesObject currObj = this.api.get(kubeconfig, apiGroup, apiVersion, kindPluralName, resourceNamespace, resourceName);
        V1ObjectMeta metadata = newObj.getMetadata();
        metadata.setResourceVersion(currObj.getMetadata().getResourceVersion());
        newObj.setMetadata(metadata);
        this.api.update(kubeconfig, apiGroup, apiVersion, kindPluralName, newObj);
    }

    public static enum OperationType {
        GET,
        CREATE,
        UPDATE;

    }
}

