/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.patterndetection.clue;

import com.redhat.parodos.patterndetection.clue.AbstractClue;
import com.redhat.parodos.patterndetection.clue.Clue;
import com.redhat.parodos.patterndetection.clue.delegate.FileContentsDelegate;
import com.redhat.parodos.patterndetection.exceptions.PatternDetectionConfigurationException;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentsClueImpl
extends AbstractClue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentsClueImpl.class);
    private Pattern targetContentPattern = null;
    private FileContentsDelegate fileContentsDelegate = new FileContentsDelegate();

    @Override
    public WorkReport execute(WorkContext workContext) {
        if (this.continueToRunIfDetected || !this.workContextDelegate.isThisClueDetected((Clue)this, workContext)) {
            for (File thisFile : this.workContextDelegate.getFilesToScan(workContext)) {
                try {
                    this.processFileForContentMatches(workContext, thisFile);
                }
                catch (IOException e) {
                    log.error("Unable to execute Scan of {} clue on File: {}", new Object[]{this.name, thisFile.getAbsolutePath(), e});
                    return new DefaultWorkReport(WorkStatus.FAILED, workContext);
                }
            }
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    private void processFileForContentMatches(WorkContext workContext, File thisFile) throws IOException {
        if (this.nameMatchingDelegate.isThisATargetFileExtension(thisFile)) {
            List<String> fileContent = this.fileContentsDelegate.fileContentsToList(thisFile);
            this.processFileContentsForContentMatch(workContext, thisFile, fileContent);
        }
    }

    private void processFileContentsForContentMatch(WorkContext workContext, File thisFile, List<String> fileContent) {
        for (String line : fileContent) {
            if (line.isEmpty() || !this.targetContentPattern.matcher(line.trim()).matches()) continue;
            this.workContextDelegate.markClueAsDetected(this, thisFile, workContext);
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentsClueImpl)) {
            return false;
        }
        ContentsClueImpl other = (ContentsClueImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Pattern this$targetContentPattern = this.getTargetContentPattern();
        Pattern other$targetContentPattern = other.getTargetContentPattern();
        if (this$targetContentPattern == null ? other$targetContentPattern != null : !this$targetContentPattern.equals(other$targetContentPattern)) {
            return false;
        }
        FileContentsDelegate this$fileContentsDelegate = this.getFileContentsDelegate();
        FileContentsDelegate other$fileContentsDelegate = other.getFileContentsDelegate();
        return !(this$fileContentsDelegate == null ? other$fileContentsDelegate != null : !this$fileContentsDelegate.equals(other$fileContentsDelegate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContentsClueImpl;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Pattern $targetContentPattern = this.getTargetContentPattern();
        result = result * 59 + ($targetContentPattern == null ? 43 : $targetContentPattern.hashCode());
        FileContentsDelegate $fileContentsDelegate = this.getFileContentsDelegate();
        result = result * 59 + ($fileContentsDelegate == null ? 43 : $fileContentsDelegate.hashCode());
        return result;
    }

    @Generated
    public ContentsClueImpl() {
    }

    @Generated
    public Pattern getTargetContentPattern() {
        return this.targetContentPattern;
    }

    @Generated
    public FileContentsDelegate getFileContentsDelegate() {
        return this.fileContentsDelegate;
    }

    @Generated
    public void setTargetContentPattern(Pattern targetContentPattern) {
        this.targetContentPattern = targetContentPattern;
    }

    @Generated
    public void setFileContentsDelegate(FileContentsDelegate fileContentsDelegate) {
        this.fileContentsDelegate = fileContentsDelegate;
    }

    @Override
    @Generated
    public String toString() {
        return "ContentsClueImpl(targetContentPattern=" + this.getTargetContentPattern() + ", fileContentsDelegate=" + this.getFileContentsDelegate() + ")";
    }

    public static class Builder
    extends AbstractClue.Builder<Builder> {
        String targetContentPatternString;

        Builder() {
        }

        public Builder targetContentPatternString(String targetContentPatternString) {
            if (targetContentPatternString == null || targetContentPatternString.isEmpty()) {
                throw new PatternDetectionConfigurationException("The targetContentPattern must not be blank or null for a ContentsClue");
            }
            this.targetContentPatternString = targetContentPatternString;
            return this;
        }

        public ContentsClueImpl build() {
            ContentsClueImpl instance = new ContentsClueImpl();
            try {
                instance.setTargetContentPattern(Pattern.compile(this.targetContentPatternString));
            }
            catch (PatternSyntaxException patternException) {
                throw new PatternDetectionConfigurationException(this.targetContentPatternString + " is not a valid pattern. " + patternException.getMessage());
            }
            return super.build(instance);
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

