/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.patterndetection.clue.delegate;

import java.io.File;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameMatchingDelegate {
    private static final Logger log = LoggerFactory.getLogger(NameMatchingDelegate.class);
    Pattern targetFileNameRegexPattern;
    Pattern targetFileExtensionPattern;
    Pattern ignoreFileNamePattern;
    boolean isFolder;

    private NameMatchingDelegate() {
    }

    public boolean doesNameMatch(String name) {
        return this.targetFileNameRegexPattern.matcher(name).matches();
    }

    public boolean isThisATargetFileExtension(File file) {
        if (this.getExtensionByStringHandling(file.getName()).isPresent() && this.targetFileExtensionPattern != null) {
            return this.targetFileExtensionPattern.matcher(this.getExtensionByStringHandling(file.getName()).get()).matches();
        }
        log.warn("Trying to check for a file extension with a file the extension could not be obtained for: {}", (Object)file.getName());
        return true;
    }

    public boolean shouldProcessFile(File currentFile) {
        if (this.isIgnoreFileNameDefined()) {
            return !this.ignoreFileNamePattern.matcher(currentFile.getName()).matches();
        }
        if (this.targetFileExtensionPattern != null) {
            Optional<String> extension = this.getExtensionByStringHandling(currentFile.getAbsolutePath());
            return extension.isPresent() && !this.targetFileExtensionPattern.matcher(extension.get()).matches();
        }
        if (this.targetFileNameRegexPattern != null) {
            return this.targetFileNameRegexPattern.matcher(currentFile.getName()).matches();
        }
        return true;
    }

    boolean isIgnoreFileNameDefined() {
        return this.ignoreFileNamePattern != null;
    }

    Optional<String> getExtensionByStringHandling(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(46)));
    }

    public Pattern getTargetFileNameRegexPattern() {
        return this.targetFileNameRegexPattern;
    }

    public Pattern getTargetFileExtensionPattern() {
        return this.targetFileExtensionPattern;
    }

    public Pattern getIgnoreFileNamePattern() {
        return this.ignoreFileNamePattern;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void setTargetFileNameRegexPattern(Pattern targetFileNameRegexPattern) {
        this.targetFileNameRegexPattern = targetFileNameRegexPattern;
    }

    public void setTargetFileExtensionPattern(Pattern targetFileExtensionPattern) {
        this.targetFileExtensionPattern = targetFileExtensionPattern;
    }

    public void setIgnoreFileNamePattern(Pattern ignoreFileNamePattern) {
        this.ignoreFileNamePattern = ignoreFileNamePattern;
    }

    public void setFolder(boolean isFolder) {
        this.isFolder = isFolder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NameMatchingDelegate)) {
            return false;
        }
        NameMatchingDelegate other = (NameMatchingDelegate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFolder() != other.isFolder()) {
            return false;
        }
        Pattern this$targetFileNameRegexPattern = this.getTargetFileNameRegexPattern();
        Pattern other$targetFileNameRegexPattern = other.getTargetFileNameRegexPattern();
        if (this$targetFileNameRegexPattern == null ? other$targetFileNameRegexPattern != null : !this$targetFileNameRegexPattern.equals(other$targetFileNameRegexPattern)) {
            return false;
        }
        Pattern this$targetFileExtensionPattern = this.getTargetFileExtensionPattern();
        Pattern other$targetFileExtensionPattern = other.getTargetFileExtensionPattern();
        if (this$targetFileExtensionPattern == null ? other$targetFileExtensionPattern != null : !this$targetFileExtensionPattern.equals(other$targetFileExtensionPattern)) {
            return false;
        }
        Pattern this$ignoreFileNamePattern = this.getIgnoreFileNamePattern();
        Pattern other$ignoreFileNamePattern = other.getIgnoreFileNamePattern();
        return !(this$ignoreFileNamePattern == null ? other$ignoreFileNamePattern != null : !this$ignoreFileNamePattern.equals(other$ignoreFileNamePattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NameMatchingDelegate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFolder() ? 79 : 97);
        Pattern $targetFileNameRegexPattern = this.getTargetFileNameRegexPattern();
        result = result * 59 + ($targetFileNameRegexPattern == null ? 43 : $targetFileNameRegexPattern.hashCode());
        Pattern $targetFileExtensionPattern = this.getTargetFileExtensionPattern();
        result = result * 59 + ($targetFileExtensionPattern == null ? 43 : $targetFileExtensionPattern.hashCode());
        Pattern $ignoreFileNamePattern = this.getIgnoreFileNamePattern();
        result = result * 59 + ($ignoreFileNamePattern == null ? 43 : $ignoreFileNamePattern.hashCode());
        return result;
    }

    public String toString() {
        return "NameMatchingDelegate(targetFileNameRegexPattern=" + this.getTargetFileNameRegexPattern() + ", targetFileExtensionPattern=" + this.getTargetFileExtensionPattern() + ", ignoreFileNamePattern=" + this.getIgnoreFileNamePattern() + ", isFolder=" + this.isFolder() + ")";
    }

    public static class Builder {
        private Builder() {
        }

        public static NameMatchingDelegateBuilder aNewNameMatchingDelegate() {
            return new NameMatchingDelegateBuilder();
        }

        public static class NameMatchingDelegateBuilder {
            private String targetFileNamePatternString;
            private String targetFileExtensionPatternString;
            private String ignoreFileNamePatternString;
            private boolean isFolder;

            NameMatchingDelegateBuilder() {
            }

            public NameMatchingDelegateBuilder targetFileNamePattern(String targetFileNamePatternString) {
                this.targetFileNamePatternString = targetFileNamePatternString;
                return this;
            }

            public NameMatchingDelegateBuilder isFolder(boolean isFolder) {
                this.isFolder = isFolder;
                return this;
            }

            public NameMatchingDelegateBuilder targetFileExtensionPattern(String targetFileExtensionPatternString) {
                this.targetFileExtensionPatternString = targetFileExtensionPatternString;
                return this;
            }

            public NameMatchingDelegateBuilder ignoreFileNamePattern(String ignoreFileNamePatternString) {
                this.ignoreFileNamePatternString = ignoreFileNamePatternString;
                return this;
            }

            public NameMatchingDelegate build() {
                NameMatchingDelegate instance = new NameMatchingDelegate();
                if (this.ignoreFileNamePatternString != null) {
                    instance.setIgnoreFileNamePattern(Pattern.compile(this.ignoreFileNamePatternString));
                }
                if (this.targetFileExtensionPatternString != null) {
                    instance.setTargetFileExtensionPattern(Pattern.compile(this.targetFileExtensionPatternString));
                }
                if (this.targetFileNamePatternString != null) {
                    instance.setTargetFileNameRegexPattern(Pattern.compile(this.targetFileNamePatternString));
                }
                instance.setFolder(this.isFolder);
                return instance;
            }
        }
    }
}

