/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.patterndetection.clue.delegate;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileContentsDelegate {
    public List<String> getFilePaths(String basePath) throws IOException {
        List<String> filePaths;
        if (!this.doesTargetDirectoryExist(basePath)) {
            throw new IOException("Supplied path to scan: " + basePath + " does not exist");
        }
        Throwable throwable = null;
        Object var4_4 = null;
        try (Stream<Path> walk = Files.walk(Paths.get(basePath, new String[0]), new FileVisitOption[0]);){
            filePaths = walk.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return filePaths;
    }

    private boolean doesTargetDirectoryExist(String basePath) {
        if (basePath == null) {
            return false;
        }
        return new File(basePath).exists();
    }

    public List<String> getFolderPaths(String basePath) {
        File f = new File(basePath);
        ArrayList<String> paths = new ArrayList<String>();
        this.getPaths(f, basePath, paths);
        return paths;
    }

    public void getPaths(File dir, String base, List<String> paths) {
        File[] files;
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                paths.add(file.getPath().replace(base, ""));
                this.getPaths(file, base, paths);
            }
            ++n2;
        }
    }

    public List<String> fileContentsToList(File currentFile) throws IOException {
        List<String> fileContent;
        Throwable throwable = null;
        Object var4_4 = null;
        try (Stream<String> stream = Files.lines(Paths.get(currentFile.getCanonicalPath(), new String[0]));){
            fileContent = stream.collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return fileContent;
    }
}

