/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.patterndetection.clue;

import com.redhat.parodos.patterndetection.clue.Clue;
import com.redhat.parodos.patterndetection.clue.delegate.NameMatchingDelegate;
import com.redhat.parodos.patterndetection.context.WorkContextDelegate;
import java.util.UUID;

public abstract class AbstractClue
implements Clue {
    WorkContextDelegate workContextDelegate = new WorkContextDelegate();
    NameMatchingDelegate nameMatchingDelegate;
    String name;
    boolean continueToRunIfDetected;

    void setName(String name) {
        if (name == null || name.isEmpty()) {
            name = UUID.randomUUID().toString();
        }
        this.name = name;
    }

    public WorkContextDelegate getWorkContextDelegate() {
        return this.workContextDelegate;
    }

    public NameMatchingDelegate getNameMatchingDelegate() {
        return this.nameMatchingDelegate;
    }

    public String getName() {
        return this.name;
    }

    public boolean isContinueToRunIfDetected() {
        return this.continueToRunIfDetected;
    }

    public void setWorkContextDelegate(WorkContextDelegate workContextDelegate) {
        this.workContextDelegate = workContextDelegate;
    }

    public void setNameMatchingDelegate(NameMatchingDelegate nameMatchingDelegate) {
        this.nameMatchingDelegate = nameMatchingDelegate;
    }

    public void setContinueToRunIfDetected(boolean continueToRunIfDetected) {
        this.continueToRunIfDetected = continueToRunIfDetected;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractClue)) {
            return false;
        }
        AbstractClue other = (AbstractClue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isContinueToRunIfDetected() != other.isContinueToRunIfDetected()) {
            return false;
        }
        WorkContextDelegate this$workContextDelegate = this.getWorkContextDelegate();
        WorkContextDelegate other$workContextDelegate = other.getWorkContextDelegate();
        if (this$workContextDelegate == null ? other$workContextDelegate != null : !this$workContextDelegate.equals(other$workContextDelegate)) {
            return false;
        }
        NameMatchingDelegate this$nameMatchingDelegate = this.getNameMatchingDelegate();
        NameMatchingDelegate other$nameMatchingDelegate = other.getNameMatchingDelegate();
        if (this$nameMatchingDelegate == null ? other$nameMatchingDelegate != null : !((Object)this$nameMatchingDelegate).equals(other$nameMatchingDelegate)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractClue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isContinueToRunIfDetected() ? 79 : 97);
        WorkContextDelegate $workContextDelegate = this.getWorkContextDelegate();
        result = result * 59 + ($workContextDelegate == null ? 43 : $workContextDelegate.hashCode());
        NameMatchingDelegate $nameMatchingDelegate = this.getNameMatchingDelegate();
        result = result * 59 + ($nameMatchingDelegate == null ? 43 : ((Object)$nameMatchingDelegate).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractClue(workContextDelegate=" + this.getWorkContextDelegate() + ", nameMatchingDelegate=" + this.getNameMatchingDelegate() + ", name=" + this.getName() + ", continueToRunIfDetected=" + this.isContinueToRunIfDetected() + ")";
    }

    public static class Builder<T extends Builder<T>> {
        String name;
        boolean continueToRunIfDetected;
        String targetFileNamePatternString;
        String targetFileExtensionPatternString;
        String ignoreFileNamePatternString;

        public T targetFileNamePatternString(String targetFileNamePatternString) {
            this.targetFileNamePatternString = targetFileNamePatternString;
            return (T)this;
        }

        public T ignoreFileNamePatternString(String ignoreFileNamePatternString) {
            this.ignoreFileNamePatternString = ignoreFileNamePatternString;
            return (T)this;
        }

        public T targetFileExtensionPatternString(String targetFileExtensionPatternString) {
            this.targetFileExtensionPatternString = targetFileExtensionPatternString;
            return (T)this;
        }

        public NameMatchingDelegate getNameMatchingDelegate() {
            return NameMatchingDelegate.Builder.aNewNameMatchingDelegate().ignoreFileNamePattern(this.ignoreFileNamePatternString).targetFileExtensionPattern(this.targetFileExtensionPatternString).targetFileNamePattern(this.targetFileNamePatternString).build();
        }

        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        public T continueToRunIfDetected(boolean continueToRunIfDetected) {
            this.continueToRunIfDetected = continueToRunIfDetected;
            return (T)this;
        }

        public <S extends AbstractClue> S build(S instance) {
            instance.setName(this.name);
            instance.setNameMatchingDelegate(this.getNameMatchingDelegate());
            instance.setContinueToRunIfDetected(this.continueToRunIfDetected);
            return instance;
        }
    }
}

