/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.patterndetection.context;

import com.redhat.parodos.patterndetection.clue.Clue;
import com.redhat.parodos.patterndetection.context.WorkFlowConstants;
import com.redhat.parodos.patterndetection.pattern.Pattern;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkContextDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkContextDelegate.class);

    public boolean validateAndIntializeContext(WorkContext context) {
        if (context == null) {
            log.error("Context was null. Please define a WorkContext reference");
            return false;
        }
        if (context.get(WorkFlowConstants.START_DIRECTORY.toString()) == null && context.get(WorkFlowConstants.START_FILE.toString()) == null) {
            log.error("No target destination to scan defined. Ensure the WorkContext contains an {} entry of type String, or an {} entry of type String", (Object)WorkFlowConstants.START_DIRECTORY, (Object)WorkFlowConstants.START_FILE);
            return false;
        }
        for (Pattern pattern : this.getDesiredPatterns(context)) {
            if (!pattern.getAllAreRequiredClues().isEmpty() || !pattern.getOnlyOneIsRequiredClues().isEmpty()) continue;
            log.error("Pattern {} does not have any associated Clues. Running this Scan will never result in anything being detected", (Object)pattern.getName());
        }
        this.initializeContext(context);
        this.getFilesAndDirectoriesFromRoot(context);
        return true;
    }

    public boolean areAllPatternsDetected(WorkReport report) {
        int numberOfTargetStatesFound;
        int numberOfTargetStatesRequired = ((List)report.getWorkContext().get(WorkFlowConstants.DESIRED_PATTERNS.toString())).size();
        return numberOfTargetStatesRequired == (numberOfTargetStatesFound = ((List)report.getWorkContext().get(WorkFlowConstants.DETECTED_PATTERNS.toString())).size());
    }

    public Set<File> getFilesToScan(WorkContext context) {
        return (Set)context.get(WorkFlowConstants.FILES_TO_SCAN.toString());
    }

    public Map<Clue, List<File>> getDetectedClue(WorkReport report) {
        return this.getDetectedClue(report.getWorkContext());
    }

    public Map<Clue, List<File>> getDetectedClue(WorkContext context) {
        return (Map)context.get(WorkFlowConstants.DETECTED_CLUES.toString());
    }

    public List<Pattern> getDesiredPatterns(WorkContext context) {
        return (List)context.get(WorkFlowConstants.DESIRED_PATTERNS.toString());
    }

    public List<Pattern> getDetectedPatterns(WorkReport report) {
        return this.getDetectedPatterns(report.getWorkContext());
    }

    public List<Pattern> getDetectedPatterns(WorkContext context) {
        return (List)context.get(WorkFlowConstants.DETECTED_PATTERNS.toString());
    }

    public Set<File> getFoldersToScan(WorkContext context) {
        return (Set)context.get(WorkFlowConstants.FOLDERS_TO_SCAN.toString());
    }

    public boolean isThisPatternDetected(Pattern pattern, WorkReport report) {
        for (Pattern thisPattern : (List)report.getWorkContext().get(WorkFlowConstants.DETECTED_PATTERNS.toString())) {
            if (!thisPattern.getName().equals(pattern.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isThisClueDetected(Clue clue, WorkReport report) {
        return this.getDetectedClue(report).containsKey(clue);
    }

    public boolean isThisClueDetected(Clue clue, WorkContext context) {
        return this.getDetectedClue(context).containsKey(clue);
    }

    public void markClueAsDetected(Clue clue, File file, WorkContext context) {
        if (this.getDetectedClue(context).containsKey(clue)) {
            this.getDetectedClue(context).get(clue).add(file);
        } else {
            ArrayList<File> detectedFiles = new ArrayList<File>();
            detectedFiles.add(file);
            this.getDetectedClue(context).put(clue, detectedFiles);
        }
    }

    public void processResultsAfterScan(WorkContext context) {
        for (Pattern pattern : this.getDesiredPatterns(context)) {
            boolean needAllConditionsRequired = !pattern.getAllAreRequiredClues().isEmpty();
            boolean needOneOfConditionsRequired = !pattern.getOnlyOneIsRequiredClues().isEmpty();
            boolean needAllConditionsAchieved = this.processNeedAllClue(pattern, context);
            boolean needOneOfConditionsAchieved = this.processNeedOneOfClues(pattern, context);
            boolean patternDetected = false;
            if (needAllConditionsRequired && needOneOfConditionsRequired) {
                patternDetected = needAllConditionsAchieved && needOneOfConditionsAchieved;
            } else {
                boolean bl = patternDetected = needAllConditionsRequired && needAllConditionsAchieved || needOneOfConditionsRequired && needOneOfConditionsAchieved;
            }
            if (!patternDetected) continue;
            this.getDetectedPatterns(context).add(pattern);
        }
    }

    private void getFilesAndDirectoriesFromRoot(WorkContext context) {
        HashSet<File> fileList = new HashSet<File>();
        HashSet<File> directoryList = new HashSet<File>();
        try {
            Files.walkFileTree(Paths.get((String)context.get(WorkFlowConstants.START_DIRECTORY.toString()), new String[0]), new CollectFiles(fileList, directoryList));
        }
        catch (IOException e) {
            log.error("Unable to get the folders and files to process. Start Directory: {}", context.get(WorkFlowConstants.START_DIRECTORY.toString()), (Object)e);
        }
        context.put(WorkFlowConstants.FILES_TO_SCAN.toString(), fileList);
        context.put(WorkFlowConstants.FOLDERS_TO_SCAN.toString(), directoryList);
    }

    private void initializeContext(WorkContext context) {
        context.put(WorkFlowConstants.DETECTED_CLUES.toString(), new HashMap());
        context.put(WorkFlowConstants.DETECTED_PATTERNS.toString(), new ArrayList());
    }

    private boolean processNeedOneOfClues(Pattern pattern, WorkContext context) {
        for (Clue clue : pattern.getOnlyOneIsRequiredClues()) {
            if (!this.isThisClueDetected(clue, context)) continue;
            return true;
        }
        return false;
    }

    private boolean processNeedAllClue(Pattern pattern, WorkContext context) {
        long numberToFind = pattern.getAllAreRequiredClues().size();
        long numberFound = 0L;
        for (Clue clue : pattern.getAllAreRequiredClues()) {
            if (!this.isThisClueDetected(clue, context)) continue;
            ++numberFound;
        }
        return numberToFind == numberFound;
    }

    class CollectFiles
    extends SimpleFileVisitor<Path> {
        Set<File> fileList;
        Set<File> directoryList;

        public CollectFiles(Set<File> fileList, Set<File> directoryList) {
            this.fileList = fileList;
            this.directoryList = directoryList;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            this.fileList.add(file.toFile());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            this.directoryList.add(dir.toFile());
            return FileVisitResult.CONTINUE;
        }
    }

    public static class WorkContextBuilder {
        private List<Pattern> desiredPatterns = new ArrayList<Pattern>();
        private String startDirectory;

        public static WorkContextBuilder builder() {
            return new WorkContextBuilder();
        }

        WorkContextBuilder() {
        }

        public WorkContextBuilder startDirectory(String startDirectory) {
            this.startDirectory = startDirectory;
            return this;
        }

        public WorkContextBuilder addThisToDesiredPatterns(Pattern pattern) {
            this.desiredPatterns.add(pattern);
            return this;
        }

        public WorkContextBuilder addTheseToDesiredPatterns(List<Pattern> newDesiredPatterns) {
            this.desiredPatterns.addAll(newDesiredPatterns);
            return this;
        }

        public WorkContext build() {
            WorkContext context = new WorkContext();
            context.put(WorkFlowConstants.START_DIRECTORY.toString(), (Object)this.startDirectory);
            context.put(WorkFlowConstants.DESIRED_PATTERNS.toString(), this.desiredPatterns);
            return context;
        }
    }
}

