/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.patterndetection.pattern;

import com.redhat.parodos.patterndetection.ScanningThreadPool;
import com.redhat.parodos.patterndetection.clue.Clue;
import com.redhat.parodos.patterndetection.exceptions.PatternDetectionConfigurationException;
import com.redhat.parodos.patterndetection.pattern.Pattern;
import com.redhat.parodos.workflows.work.Work;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.workflow.ParallelFlow;
import com.redhat.parodos.workflows.workflow.WorkFlowPropertiesMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicPatternImpl
implements Pattern {
    private WorkFlowPropertiesMetadata properties;
    private final List<Clue> allAreRequiredClues;
    private final List<Clue> onlyOneIsRequiredClues;

    public void setProperties(WorkFlowPropertiesMetadata properties) {
        this.properties = properties;
    }

    public WorkFlowPropertiesMetadata getProperties() {
        return this.properties;
    }

    BasicPatternImpl(List<Clue> allAreRequiredClues, List<Clue> onlyOneIsRequiredClues) {
        this.allAreRequiredClues = allAreRequiredClues;
        this.onlyOneIsRequiredClues = onlyOneIsRequiredClues;
    }

    public WorkReport execute(WorkContext workContext) {
        return ParallelFlow.Builder.aNewParallelFlow().execute(this.combineAllClues()).with(ScanningThreadPool.getThreadPoolExecutor()).build().execute(workContext);
    }

    private Work[] combineAllClues() {
        ArrayList<Clue> allClues = new ArrayList<Clue>();
        allClues.addAll(this.allAreRequiredClues);
        allClues.addAll(this.onlyOneIsRequiredClues);
        return (Work[])allClues.stream().toArray(Work[]::new);
    }

    public List<Clue> getAllAreRequiredClues() {
        return this.allAreRequiredClues;
    }

    public List<Clue> getOnlyOneIsRequiredClues() {
        return this.onlyOneIsRequiredClues;
    }

    public static class Builder {
        private Builder() {
        }

        public static PatternImplBuilder aNewPattern() {
            return new PatternImplBuilder();
        }

        public static class PatternImplBuilder {
            private List<Clue> allAreRequiredClues = new ArrayList<Clue>();
            private List<Clue> onlyOneIsRequiredClues = new ArrayList<Clue>();

            public PatternImplBuilder addThiToOneIsRequiredClues(Clue clue) {
                return this.addTheseToOneOfTheseClues(Collections.singletonList(clue));
            }

            public PatternImplBuilder addTheseToOneOfTheseClues(List<Clue> conditions) {
                if (conditions == null) {
                    throw new PatternDetectionConfigurationException("OnOfTheseClues list cannot be null");
                }
                if (!conditions.isEmpty()) {
                    this.onlyOneIsRequiredClues.addAll(conditions);
                }
                return this;
            }

            public PatternImplBuilder addThisToAllAreRequiredClues(Clue clue) {
                return this.addTheseToAllCluesRequired(Collections.singletonList(clue));
            }

            public PatternImplBuilder addTheseToAllCluesRequired(List<Clue> clues) {
                if (clues == null) {
                    throw new PatternDetectionConfigurationException("AllRequiredClues list cannot be null");
                }
                if (!clues.isEmpty()) {
                    this.allAreRequiredClues.addAll(clues);
                }
                return this;
            }

            PatternImplBuilder() {
            }

            public BasicPatternImpl build() {
                return new BasicPatternImpl(this.allAreRequiredClues, this.onlyOneIsRequiredClues);
            }
        }
    }
}

