/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.patterndetection.clue;

import com.redhat.parodos.patterndetection.clue.AbstractClue;
import com.redhat.parodos.patterndetection.clue.Clue;
import com.redhat.parodos.patterndetection.clue.delegate.FileContentsDelegate;
import com.redhat.parodos.patterndetection.exceptions.ClueConfigurationException;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;

public class NameClueImpl
extends AbstractClue {
    private FileContentsDelegate fileContentsDelegate = new FileContentsDelegate();
    Pattern targetFileNameRegexPattern;

    @Override
    public WorkReport execute(WorkContext workContext) {
        if (this.continueToRunIfDetected || !this.workContextDelegate.isThisClueDetected((Clue)this, workContext)) {
            Set<File> filesToScan = this.nameMatchingDelegate.isFolder() ? this.workContextDelegate.getFoldersToScan(workContext) : this.workContextDelegate.getFilesToScan(workContext);
            for (File thisFile : filesToScan) {
                boolean matched = this.targetFileNameRegexPattern != null ? this.targetFileNameRegexPattern.matcher(thisFile.getName()).matches() : this.nameMatchingDelegate.doesNameMatch(thisFile.getName());
                if (!matched) continue;
                this.workContextDelegate.markClueAsDetected(this, thisFile, workContext);
            }
        }
        return new DefaultWorkReport(WorkStatus.COMPLETED, workContext);
    }

    @Generated
    public NameClueImpl() {
    }

    @Generated
    public FileContentsDelegate getFileContentsDelegate() {
        return this.fileContentsDelegate;
    }

    @Generated
    public Pattern getTargetFileNameRegexPattern() {
        return this.targetFileNameRegexPattern;
    }

    @Generated
    public void setFileContentsDelegate(FileContentsDelegate fileContentsDelegate) {
        this.fileContentsDelegate = fileContentsDelegate;
    }

    @Generated
    public void setTargetFileNameRegexPattern(Pattern targetFileNameRegexPattern) {
        this.targetFileNameRegexPattern = targetFileNameRegexPattern;
    }

    @Override
    @Generated
    public String toString() {
        return "NameClueImpl(fileContentsDelegate=" + this.getFileContentsDelegate() + ", targetFileNameRegexPattern=" + this.getTargetFileNameRegexPattern() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NameClueImpl)) {
            return false;
        }
        NameClueImpl other = (NameClueImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileContentsDelegate this$fileContentsDelegate = this.getFileContentsDelegate();
        FileContentsDelegate other$fileContentsDelegate = other.getFileContentsDelegate();
        if (this$fileContentsDelegate == null ? other$fileContentsDelegate != null : !this$fileContentsDelegate.equals(other$fileContentsDelegate)) {
            return false;
        }
        Pattern this$targetFileNameRegexPattern = this.getTargetFileNameRegexPattern();
        Pattern other$targetFileNameRegexPattern = other.getTargetFileNameRegexPattern();
        return !(this$targetFileNameRegexPattern == null ? other$targetFileNameRegexPattern != null : !this$targetFileNameRegexPattern.equals(other$targetFileNameRegexPattern));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NameClueImpl;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileContentsDelegate $fileContentsDelegate = this.getFileContentsDelegate();
        result = result * 59 + ($fileContentsDelegate == null ? 43 : $fileContentsDelegate.hashCode());
        Pattern $targetFileNameRegexPattern = this.getTargetFileNameRegexPattern();
        result = result * 59 + ($targetFileNameRegexPattern == null ? 43 : $targetFileNameRegexPattern.hashCode());
        return result;
    }

    public static class Builder
    extends AbstractClue.Builder<Builder> {
        private String fileNamePatternString;

        Builder() {
        }

        @Override
        public Builder targetFileNamePatternString(String fileNamePatternString) {
            this.fileNamePatternString = fileNamePatternString;
            return this;
        }

        public NameClueImpl build() {
            NameClueImpl instance = super.build(new NameClueImpl());
            if (this.fileNamePatternString != null) {
                instance.setTargetFileNameRegexPattern(Pattern.compile(this.fileNamePatternString));
            } else if (super.getNameMatchingDelegate().getTargetFileNameRegexPattern() == null) {
                throw new ClueConfigurationException("Name Clue " + instance.getName() + " must contain a fileNamePatternString or a NameMatchingDelegate.targetFileNamePatternString");
            }
            return instance;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

