/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.task;

import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.WorkFlowTask;
import com.redhat.parodos.workflow.utils.WorkContextUtils;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class BaseWorkFlowTask
implements WorkFlowTask,
BeanNameAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseWorkFlowTask.class);
    private String name;
    private List<WorkFlow> workFlowCheckers;

    public void setBeanName(String name) {
        this.name = name;
    }

    public List<WorkFlow> getWorkFlowCheckers() {
        return this.workFlowCheckers;
    }

    public void setWorkFlowCheckers(List<WorkFlow> workFlowCheckers) {
        this.workFlowCheckers = workFlowCheckers;
    }

    public String getProjectId(WorkContext workContext) {
        return WorkContextUtils.getProjectId(workContext);
    }

    public String getMainExecutionId(WorkContext workContext) {
        return WorkContextUtils.getMainExecutionId(workContext);
    }

    public void addParameter(WorkContext workContext, String key, String value) {
        WorkContextUtils.addParameter(workContext, key, value);
    }

    public Map<String, String> getAllParameters(WorkContext workContext) {
        return WorkContextUtils.getAllParameters(workContext, this.name);
    }

    public String getRequiredParameterValue(WorkContext workContext, String parameterName) throws MissingParameterException {
        Map<String, String> parameters = this.getAllParameters(workContext);
        return parameters.entrySet().stream().filter(entry -> parameterName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> {
            log.error(String.format("parameter %s is not provided for task %s!", parameterName, this.name));
            return new MissingParameterException("missing parameter(s) for ParameterName: " + parameterName);
        });
    }

    public String getOptionalParameterValue(WorkContext workContext, String parameterName, String defaultValue) {
        Map<String, String> parameters = this.getAllParameters(workContext);
        return parameters.entrySet().stream().filter(entry -> parameterName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(defaultValue);
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

