/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflows.work.WorkContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class WorkContextUtils {
    private WorkContextUtils() {
    }

    public static String getProjectId(WorkContext workContext) {
        return WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.PROJECT, WorkContextDelegate.Resource.ID).toString();
    }

    public static String getMainExecutionId(WorkContext workContext) {
        return WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ID).toString();
    }

    public static void addParameter(WorkContext workContext, String key, String value) {
        Map parameterMap = Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap());
        parameterMap.put(key, value);
        WorkContextDelegate.write(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ARGUMENTS, parameterMap);
    }

    public static Map<String, String> getAllParameters(WorkContext workContext, String name) {
        Map parameters = Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_TASK_EXECUTION, name, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap());
        parameters.putAll(Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap()));
        parameters.putAll(WorkContextUtils.getParentParameters(workContext, name));
        return parameters;
    }

    private static Map<String, String> getParentParameters(WorkContext workContext, String workName) {
        String parentWorkflowName = (String)WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, workName, WorkContextDelegate.Resource.PARENT_WORKFLOW);
        HashMap<String, String> map = new HashMap<String, String>();
        Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, workName, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).ifPresent(map::putAll);
        if (parentWorkflowName != null) {
            map.putAll(WorkContextUtils.getParentParameters(workContext, parentWorkflowName));
        }
        return map;
    }
}

