/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.task;

import com.redhat.parodos.workflow.parameter.WorkParameter;
import com.redhat.parodos.workflow.task.enums.WorkFlowTaskOutput;
import com.redhat.parodos.workflows.work.Work;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public interface WorkFlowTask
extends Work {
    @NonNull
    default public List<WorkParameter> getWorkFlowTaskParameters() {
        return Collections.emptyList();
    }

    @NonNull
    default public List<WorkFlowTaskOutput> getWorkFlowTaskOutputs() {
        return Collections.emptyList();
    }

    default public HashMap<String, Map<String, Object>> getAsJsonSchema() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (WorkParameter workParameter : this.getWorkFlowTaskParameters()) {
            if (workParameter == null || workParameter.getType() == null) continue;
            Map<String, Object> properties = workParameter.getType().getAsJsonSchema();
            properties.put("required", !workParameter.isOptional());
            properties.put("description", workParameter.getDescription());
            if (workParameter.getType().isSelect() && workParameter.getSelectOptions() != null) {
                properties.put("enum", workParameter.getSelectOptions());
            }
            if (workParameter.getJsonSchemaOptions() != null) {
                properties.putAll(workParameter.getJsonSchemaOptions());
            }
            result.put(workParameter.getKey(), properties);
        }
        return result;
    }
}

