/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.parameter;

import java.util.HashMap;
import java.util.Map;

public enum WorkFlowParameterType {
    PASSWORD,
    TEXT,
    EMAIL,
    DATE,
    NUMBER,
    URL;


    public Map<String, Object> getAsJsonSchema() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        switch (this) {
            case PASSWORD: {
                properties.put("type", "string");
                properties.put("format", "password");
                break;
            }
            case TEXT: {
                properties.put("type", "string");
                properties.put("format", "text");
                break;
            }
            case EMAIL: {
                properties.put("type", "string");
                properties.put("format", "email");
                break;
            }
            case NUMBER: {
                properties.put("type", "number");
                break;
            }
            case URL: {
                properties.put("type", "string");
                properties.put("format", "url");
                break;
            }
            case DATE: {
                properties.put("type", "string");
                properties.put("format", "date");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter type");
            }
        }
        return properties;
    }
}

