/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.task;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.WorkFlowTask;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class BaseWorkFlowTask
implements WorkFlowTask,
BeanNameAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseWorkFlowTask.class);
    private String name;
    private List<WorkFlow> workFlowCheckers;

    public void setBeanName(String name) {
        this.name = name;
    }

    public List<WorkFlow> getWorkFlowCheckers() {
        return this.workFlowCheckers;
    }

    public void setWorkFlowCheckers(List<WorkFlow> workFlowCheckers) {
        this.workFlowCheckers = workFlowCheckers;
    }

    public String getRequiredParameterValue(WorkContext workContext, String parameterName) throws MissingParameterException {
        Map parameters = Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_TASK_EXECUTION, this.name, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap());
        parameters.putAll(this.getParentParameters(workContext, this.getName()));
        return parameters.entrySet().stream().filter(entry -> parameterName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> {
            log.error(String.format("parameter %s is not provided for task %s!", parameterName, this.name));
            return new MissingParameterException("missing parameter(s) for ParameterName: " + parameterName);
        });
    }

    public String getOptionalParameterValue(WorkContext workContext, String parameterName, String defaultValue) {
        Map parameters = Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_TASK_EXECUTION, this.name, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap());
        parameters.putAll(this.getParentParameters(workContext, this.getName()));
        return parameters.entrySet().stream().filter(entry -> parameterName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(defaultValue);
    }

    private Map<String, String> getParentParameters(WorkContext workContext, String workName) {
        String parentWorkflowName = (String)WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, workName, WorkContextDelegate.Resource.PARENT_WORKFLOW);
        HashMap<String, String> map = new HashMap<String, String>();
        Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, workName, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).ifPresent(map::putAll);
        if (parentWorkflowName != null) {
            map.putAll(this.getParentParameters(workContext, parentWorkflowName));
        }
        return map;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

