/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.option;

import com.redhat.parodos.workflow.option.WorkFlowOption;
import java.util.ArrayList;
import java.util.List;

public class WorkFlowOptions {
    private WorkFlowOption currentVersion;
    private List<WorkFlowOption> upgradeOptions;
    private List<WorkFlowOption> migrationOptions;
    private List<WorkFlowOption> newOptions;
    private List<WorkFlowOption> continuationOptions;
    private List<WorkFlowOption> otherOptions;

    public boolean isOptionsAvailable() {
        return !this.upgradeOptions.isEmpty() && !this.migrationOptions.isEmpty() && !this.newOptions.isEmpty() && !this.continuationOptions.isEmpty() && this.otherOptions.isEmpty();
    }

    public boolean hasInfrastructure() {
        return this.currentVersion == null;
    }

    public boolean hasIncompleteWorkFlow() {
        return !this.continuationOptions.isEmpty();
    }

    public WorkFlowOption getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(WorkFlowOption currentVersion) {
        this.currentVersion = currentVersion;
    }

    public List<WorkFlowOption> getContinuationOptions() {
        return this.continuationOptions;
    }

    public List<WorkFlowOption> addContinuationOption(WorkFlowOption continuationOption) {
        this.continuationOptions.add(continuationOption);
        return this.continuationOptions;
    }

    public void setContinuationOptions(List<WorkFlowOption> continuationOptions) {
        this.continuationOptions = continuationOptions;
    }

    public List<WorkFlowOption> getOtherOptions() {
        return this.otherOptions;
    }

    public List<WorkFlowOption> addOtherOption(WorkFlowOption otherOption) {
        this.otherOptions.add(otherOption);
        return this.otherOptions;
    }

    public void setOtherOptions(List<WorkFlowOption> otherOptions) {
        this.otherOptions = otherOptions;
    }

    public List<WorkFlowOption> getUpgradeOptions() {
        return this.upgradeOptions;
    }

    public List<WorkFlowOption> addUpgradeOption(WorkFlowOption upgradeOption) {
        this.upgradeOptions.add(upgradeOption);
        return this.upgradeOptions;
    }

    public void setUpgradeOptions(List<WorkFlowOption> upgradeOptions) {
        this.upgradeOptions = upgradeOptions;
    }

    public List<WorkFlowOption> addMigrationOption(WorkFlowOption migrationOption) {
        this.migrationOptions.add(migrationOption);
        return this.migrationOptions;
    }

    public List<WorkFlowOption> getMigrationOptions() {
        return this.migrationOptions;
    }

    public void setMigrationOptions(List<WorkFlowOption> migrationOptions) {
        this.migrationOptions = migrationOptions;
    }

    public List<WorkFlowOption> addNewInfrastrutureOption(WorkFlowOption newOption) {
        this.newOptions.add(newOption);
        return this.newOptions;
    }

    public void setNewOptions(List<WorkFlowOption> newOptions) {
        this.newOptions = newOptions;
    }

    public List<WorkFlowOption> getNewOptions() {
        return this.newOptions;
    }

    private WorkFlowOptions(Builder builder) {
        this.currentVersion = builder.currentVersion;
        this.migrationOptions = builder.migrationOptions;
        this.newOptions = builder.newOptions;
        this.upgradeOptions = builder.upgradeOptions;
        this.continuationOptions = builder.continuationOptions;
        this.otherOptions = builder.otherOptions;
    }

    public static class Builder {
        private WorkFlowOption currentVersion;
        private List<WorkFlowOption> upgradeOptions = new ArrayList<WorkFlowOption>();
        private List<WorkFlowOption> migrationOptions = new ArrayList<WorkFlowOption>();
        private List<WorkFlowOption> newOptions = new ArrayList<WorkFlowOption>();
        private List<WorkFlowOption> continuationOptions = new ArrayList<WorkFlowOption>();
        private List<WorkFlowOption> otherOptions = new ArrayList<WorkFlowOption>();

        public Builder setCurrentInfrastructure(WorkFlowOption currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public Builder addContinuationOption(WorkFlowOption continuationOption) {
            this.continuationOptions.add(continuationOption);
            return this;
        }

        public Builder addNewOption(WorkFlowOption newOption) {
            this.newOptions.add(newOption);
            return this;
        }

        public Builder addUpgradeOption(WorkFlowOption updgradeOption) {
            this.upgradeOptions.add(updgradeOption);
            return this;
        }

        public Builder addMigrationOption(WorkFlowOption migrationOption) {
            this.migrationOptions.add(migrationOption);
            return this;
        }

        public Builder addOtherOption(WorkFlowOption otherOption) {
            this.otherOptions.add(otherOption);
            return this;
        }

        public WorkFlowOptions build() {
            return new WorkFlowOptions(this);
        }
    }
}

