/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.parameter;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum WorkParameterType {
    PASSWORD,
    TEXT,
    EMAIL,
    DATE,
    NUMBER,
    URI,
    SELECT,
    MULTI_SELECT;


    private EnumSet<WorkParameterType> selectedTypes() {
        return EnumSet.of(SELECT, MULTI_SELECT);
    }

    public boolean isSelect() {
        return this.selectedTypes().contains((Object)this);
    }

    public Map<String, Object> getAsJsonSchema() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        switch (this) {
            case PASSWORD: {
                properties.put("type", "string");
                properties.put("format", "password");
                break;
            }
            case TEXT: {
                properties.put("type", "string");
                properties.put("format", "text");
                break;
            }
            case EMAIL: {
                properties.put("type", "string");
                properties.put("format", "email");
                break;
            }
            case NUMBER: {
                properties.put("type", "number");
                break;
            }
            case URI: {
                properties.put("type", "string");
                properties.put("format", "uri");
                break;
            }
            case DATE: {
                properties.put("type", "string");
                properties.put("format", "date");
                break;
            }
            case SELECT: {
                properties.put("type", "string");
                properties.put("format", "select");
                break;
            }
            case MULTI_SELECT: {
                properties.put("type", "string");
                properties.put("format", "multi-select");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid parameter type");
            }
        }
        return properties;
    }
}

