/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.redhat.parodos.workflow.context.WorkContextDelegate;
import com.redhat.parodos.workflows.work.WorkContext;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;

public abstract class WorkContextUtils {
    private WorkContextUtils() {
    }

    public static UUID getUserId(WorkContext workContext) {
        Object userId = WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.USER, WorkContextDelegate.Resource.ID);
        userId = Optional.ofNullable(userId).orElseThrow(() -> new NoSuchElementException("User id is missing from workContext."));
        return UUID.fromString(userId.toString());
    }

    public static void setUserId(WorkContext workContext, @NonNull UUID userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        WorkContextDelegate.write(workContext, WorkContextDelegate.ProcessType.USER, WorkContextDelegate.Resource.ID, userId.toString());
    }

    public static UUID getProjectId(WorkContext workContext) {
        Object projectId = WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.PROJECT, WorkContextDelegate.Resource.ID);
        projectId = Optional.ofNullable(projectId).orElseThrow(() -> new NoSuchElementException("Project id is missing from workContext."));
        return UUID.fromString(projectId.toString());
    }

    public static void setProjectId(WorkContext workContext, @NonNull UUID projectId) {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        WorkContextDelegate.write(workContext, WorkContextDelegate.ProcessType.PROJECT, WorkContextDelegate.Resource.ID, projectId.toString());
    }

    public static UUID getMainExecutionId(WorkContext workContext) {
        Object workflowExecutionId = WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ID);
        workflowExecutionId = Optional.ofNullable(workflowExecutionId).orElseThrow(() -> new NoSuchElementException("Workflow execution id is missing from workContext."));
        return UUID.fromString(workflowExecutionId.toString());
    }

    public static void setMainExecutionId(WorkContext workContext, UUID executionId) {
        WorkContextDelegate.write(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ID, executionId.toString());
    }

    public static void addParameter(WorkContext workContext, String key, String value) {
        Map parameterMap = Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap());
        parameterMap.put(key, value);
        WorkContextDelegate.write(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ARGUMENTS, parameterMap);
    }

    public static void addAdditionalInfo(WorkContext workContext, String key, String value) {
        Map additionalInfoMap = Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ADDITIONAL_INFO), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap());
        additionalInfoMap.put(key, value);
        WorkContextDelegate.write(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ADDITIONAL_INFO, additionalInfoMap);
    }

    public static Map<String, String> getAdditionalInfo(WorkContext workContext) {
        return (Map)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ADDITIONAL_INFO), (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public static Map<String, String> getAllParameters(WorkContext workContext, String name) {
        Map parameters = Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_TASK_EXECUTION, name, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap());
        parameters.putAll(Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).orElse(new HashMap()));
        parameters.putAll(WorkContextUtils.getParentParameters(workContext, name));
        return parameters;
    }

    private static Map<String, String> getParentParameters(WorkContext workContext, String workName) {
        String parentWorkflowName = (String)WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, workName, WorkContextDelegate.Resource.PARENT_WORKFLOW);
        HashMap<String, String> map = new HashMap<String, String>();
        Optional.ofNullable((HashMap)new ObjectMapper().convertValue(WorkContextDelegate.read(workContext, WorkContextDelegate.ProcessType.WORKFLOW_EXECUTION, workName, WorkContextDelegate.Resource.ARGUMENTS), (TypeReference)new TypeReference<HashMap<String, String>>(){})).ifPresent(map::putAll);
        if (parentWorkflowName != null) {
            map.putAll(WorkContextUtils.getParentParameters(workContext, parentWorkflowName));
        }
        return map;
    }

    public static void updateWorkContextPartially(WorkContext workContext, UUID projectId, UUID userId, String workflowName, UUID executionId) {
        if (executionId != null) {
            WorkContextUtils.setMainExecutionId(workContext, executionId);
        }
        WorkContextUtils.setProjectId(workContext, projectId);
        WorkContextUtils.setUserId(workContext, userId);
        WorkContextDelegate.write(workContext, WorkContextDelegate.ProcessType.WORKFLOW_DEFINITION, WorkContextDelegate.Resource.NAME, workflowName);
    }
}

