/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.task.log;

import com.redhat.parodos.workflow.enums.WorkFlowLogLevel;
import com.redhat.parodos.workflow.task.log.dto.WorkFlowTaskLog;
import com.redhat.parodos.workflow.task.log.service.WorkFlowLogService;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class WorkFlowTaskLogger {
    private UUID mainWorkFlowId;
    private String taskName;
    private WorkFlowLogService workFlowLogService;
    private Logger log;

    public void logInfo(String logText, String ... value) {
        this.logWithLogLevel(WorkFlowLogLevel.INFO, logText, value);
    }

    public void logInfoWithSlf4j(String logText, String ... value) {
        this.logInfo(logText, value);
        this.log.info(logText, (Object[])value);
    }

    public void logError(String logText, String ... value) {
        this.logWithLogLevel(WorkFlowLogLevel.ERROR, logText, value);
    }

    public void logErrorWithSlf4j(String logText, String ... value) {
        this.logError(logText, value);
        this.log.error(logText, (Object[])value);
    }

    public void logWarn(String logText, String ... value) {
        this.logWithLogLevel(WorkFlowLogLevel.WARNING, logText, value);
    }

    public void logWarnWithSlf4j(String logText, String ... value) {
        this.logWarn(logText, value);
        this.log.warn(logText, (Object[])value);
    }

    private void logWithLogLevel(WorkFlowLogLevel workFlowLoglevel, String logText, String ... value) {
        String formattedLog = value.length > 0 ? MessageFormatter.arrayFormat((String)logText, (Object[])value).getMessage() : logText;
        this.workFlowLogService.writeLog(this.mainWorkFlowId, this.taskName, WorkFlowTaskLog.builder().logText(formattedLog).workFlowLoglevel(workFlowLoglevel).build());
    }

    public WorkFlowTaskLogger(UUID mainWorkFlowId, String taskName, WorkFlowLogService workFlowLogService, Logger log) {
        this.mainWorkFlowId = mainWorkFlowId;
        this.taskName = taskName;
        this.workFlowLogService = workFlowLogService;
        this.log = log;
    }
}

