/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.task;

import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflow.task.WorkFlowTask;
import com.redhat.parodos.workflow.task.log.WorkFlowTaskLogger;
import com.redhat.parodos.workflow.task.log.service.WorkFlowLogService;
import com.redhat.parodos.workflow.utils.WorkContextUtils;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseWorkFlowTask
implements WorkFlowTask,
BeanNameAware {
    private static final Logger log = LoggerFactory.getLogger(BaseWorkFlowTask.class);
    private String name;
    @Autowired
    private WorkFlowLogService workFlowLogService;
    private WorkContext workContext;
    protected WorkFlowTaskLogger taskLogger;
    private List<WorkFlow> workFlowCheckers;

    public void setBeanName(String name) {
        this.name = name;
    }

    @Override
    public void preExecute(WorkContext workContext) {
        this.workContext = workContext;
        this.taskLogger = new WorkFlowTaskLogger(this.getMainExecutionId(), this.name, this.workFlowLogService, LoggerFactory.getLogger(this.getClass()));
    }

    public List<WorkFlow> getWorkFlowCheckers() {
        return this.workFlowCheckers;
    }

    public void setWorkFlowCheckers(List<WorkFlow> workFlowCheckers) {
        this.workFlowCheckers = workFlowCheckers;
    }

    public UUID getProjectId(WorkContext workContext) {
        return WorkContextUtils.getProjectId(workContext);
    }

    public UUID getMainExecutionId() {
        return WorkContextUtils.getMainExecutionId(this.workContext);
    }

    public void addParameter(String key, String value) {
        WorkContextUtils.addParameter(this.workContext, key, value);
    }

    public Map<String, String> getAllParameters(WorkContext workContext) {
        return WorkContextUtils.getAllParameters(workContext, this.name);
    }

    public void addAdditionInfo(String key, String value) {
        WorkContextUtils.addAdditionalInfo(this.workContext, key, value);
    }

    public String getRequiredParameterValue(String parameterName) throws MissingParameterException {
        Map<String, String> parameters = this.getAllParameters(this.workContext);
        return parameters.entrySet().stream().filter(entry -> parameterName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> {
            log.error(String.format("parameter %s is not provided for task %s!", parameterName, this.name));
            return new MissingParameterException("missing parameter(s) for ParameterName: " + parameterName);
        });
    }

    public String getOptionalParameterValue(String parameterName, String defaultValue) {
        Map<String, String> parameters = this.getAllParameters(this.workContext);
        return parameters.entrySet().stream().filter(entry -> parameterName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(defaultValue);
    }

    public String getOptionalParameterValue(String parameterName, String defaultValue, Boolean isNullable) {
        Map<String, String> parameters = this.getAllParameters(this.workContext);
        return parameters.entrySet().stream().filter(entry -> isNullable == false && !Objects.isNull(entry.getValue()) && !((String)entry.getValue()).equalsIgnoreCase("null")).filter(entry -> parameterName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(defaultValue);
    }

    public String getName() {
        return this.name;
    }
}

