/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.parameter;

import com.redhat.parodos.workflow.parameter.WorkParameterType;
import java.util.List;
import java.util.Map;

public class WorkParameter {
    private static final String REQUIRED = "required";
    private static final String DESCRIPTION = "description";
    private static final String VALUE_PROVIDER_NAME = "valueProviderName";
    private static final String ENUM = "enum";
    private String key;
    private WorkParameterType type;
    private String description;
    private boolean optional;
    private List<String> selectOptions;
    private Map<String, Object> jsonSchemaOptions;
    private String valueProviderName;

    public Map<String, Object> getAsJsonSchema() {
        if (this.type == null) {
            return Map.of();
        }
        Map<String, Object> properties = this.type.getAsJsonSchema();
        properties.put(REQUIRED, !this.optional);
        properties.put(DESCRIPTION, this.description);
        if (this.valueProviderName != null && !this.valueProviderName.isEmpty()) {
            properties.put(VALUE_PROVIDER_NAME, this.valueProviderName);
        }
        if (this.type.isSelect() && this.selectOptions != null && !this.selectOptions.isEmpty()) {
            properties.put(ENUM, this.selectOptions);
        }
        if (this.jsonSchemaOptions != null) {
            properties.putAll(this.jsonSchemaOptions);
        }
        return properties;
    }

    public static WorkParameterBuilder builder() {
        return new WorkParameterBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public WorkParameterType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public List<String> getSelectOptions() {
        return this.selectOptions;
    }

    public Map<String, Object> getJsonSchemaOptions() {
        return this.jsonSchemaOptions;
    }

    public String getValueProviderName() {
        return this.valueProviderName;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(WorkParameterType type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setSelectOptions(List<String> selectOptions) {
        this.selectOptions = selectOptions;
    }

    public void setJsonSchemaOptions(Map<String, Object> jsonSchemaOptions) {
        this.jsonSchemaOptions = jsonSchemaOptions;
    }

    public void setValueProviderName(String valueProviderName) {
        this.valueProviderName = valueProviderName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkParameter)) {
            return false;
        }
        WorkParameter other = (WorkParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        WorkParameterType this$type = this.getType();
        WorkParameterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$selectOptions = this.getSelectOptions();
        List<String> other$selectOptions = other.getSelectOptions();
        if (this$selectOptions == null ? other$selectOptions != null : !((Object)this$selectOptions).equals(other$selectOptions)) {
            return false;
        }
        Map<String, Object> this$jsonSchemaOptions = this.getJsonSchemaOptions();
        Map<String, Object> other$jsonSchemaOptions = other.getJsonSchemaOptions();
        if (this$jsonSchemaOptions == null ? other$jsonSchemaOptions != null : !((Object)this$jsonSchemaOptions).equals(other$jsonSchemaOptions)) {
            return false;
        }
        String this$valueProviderName = this.getValueProviderName();
        String other$valueProviderName = other.getValueProviderName();
        return !(this$valueProviderName == null ? other$valueProviderName != null : !this$valueProviderName.equals(other$valueProviderName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOptional() ? 79 : 97);
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        WorkParameterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $selectOptions = this.getSelectOptions();
        result = result * 59 + ($selectOptions == null ? 43 : ((Object)$selectOptions).hashCode());
        Map<String, Object> $jsonSchemaOptions = this.getJsonSchemaOptions();
        result = result * 59 + ($jsonSchemaOptions == null ? 43 : ((Object)$jsonSchemaOptions).hashCode());
        String $valueProviderName = this.getValueProviderName();
        result = result * 59 + ($valueProviderName == null ? 43 : $valueProviderName.hashCode());
        return result;
    }

    public String toString() {
        return "WorkParameter(key=" + this.getKey() + ", type=" + (Object)((Object)this.getType()) + ", description=" + this.getDescription() + ", optional=" + this.isOptional() + ", selectOptions=" + this.getSelectOptions() + ", jsonSchemaOptions=" + this.getJsonSchemaOptions() + ", valueProviderName=" + this.getValueProviderName() + ")";
    }

    public WorkParameter(String key, WorkParameterType type, String description, boolean optional, List<String> selectOptions, Map<String, Object> jsonSchemaOptions, String valueProviderName) {
        this.key = key;
        this.type = type;
        this.description = description;
        this.optional = optional;
        this.selectOptions = selectOptions;
        this.jsonSchemaOptions = jsonSchemaOptions;
        this.valueProviderName = valueProviderName;
    }

    public WorkParameter() {
    }

    public static class WorkParameterBuilder {
        private String key;
        private WorkParameterType type;
        private String description;
        private boolean optional;
        private List<String> selectOptions;
        private Map<String, Object> jsonSchemaOptions;
        private String valueProviderName;

        WorkParameterBuilder() {
        }

        public WorkParameterBuilder key(String key) {
            this.key = key;
            return this;
        }

        public WorkParameterBuilder type(WorkParameterType type) {
            this.type = type;
            return this;
        }

        public WorkParameterBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WorkParameterBuilder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public WorkParameterBuilder selectOptions(List<String> selectOptions) {
            this.selectOptions = selectOptions;
            return this;
        }

        public WorkParameterBuilder jsonSchemaOptions(Map<String, Object> jsonSchemaOptions) {
            this.jsonSchemaOptions = jsonSchemaOptions;
            return this;
        }

        public WorkParameterBuilder valueProviderName(String valueProviderName) {
            this.valueProviderName = valueProviderName;
            return this;
        }

        public WorkParameter build() {
            return new WorkParameter(this.key, this.type, this.description, this.optional, this.selectOptions, this.jsonSchemaOptions, this.valueProviderName);
        }

        public String toString() {
            return "WorkParameter.WorkParameterBuilder(key=" + this.key + ", type=" + (Object)((Object)this.type) + ", description=" + this.description + ", optional=" + this.optional + ", selectOptions=" + this.selectOptions + ", jsonSchemaOptions=" + this.jsonSchemaOptions + ", valueProviderName=" + this.valueProviderName + ")";
        }
    }
}

