/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.context;

import com.redhat.parodos.workflow.context.Visibility;
import com.redhat.parodos.workflow.exception.MissingParameterException;
import com.redhat.parodos.workflows.work.WorkContext;

public class WorkContextDelegate {
    private static final String spaceChar = " ";
    private static final String underscoreChar = "_";

    private WorkContextDelegate() {
    }

    public static String buildKey(ProcessType processType, Resource resource) {
        return String.format("%s%s%s", processType.name(), underscoreChar, resource.name()).toUpperCase();
    }

    public static String buildKey(ProcessType processType, String workflowTaskName, Resource resource) {
        return String.format("%s%s%s%s%s", processType.name(), underscoreChar, workflowTaskName.replace(spaceChar, underscoreChar), underscoreChar, resource.name()).toUpperCase();
    }

    public static Object read(WorkContext workContext, ProcessType processType, String workflowTaskName, Resource resource) {
        return workContext.get(WorkContextDelegate.buildKey(processType, workflowTaskName, resource));
    }

    public static void write(WorkContext workContext, ProcessType processType, String workName, Resource resource, Object object) {
        workContext.put(WorkContextDelegate.buildKey(processType, workName, resource), object);
    }

    public static Object read(WorkContext workContext, ProcessType processType, Resource resource) {
        return workContext.get(WorkContextDelegate.buildKey(processType, resource));
    }

    public static void write(WorkContext workContext, ProcessType processType, Resource resource, Object object) {
        workContext.put(WorkContextDelegate.buildKey(processType, resource), object);
    }

    public static String getRequiredValueFromRequestParams(WorkContext workContext, String key) throws MissingParameterException {
        if (workContext.get(key) == null) {
            throw new MissingParameterException("For this task the WorkContext required key: " + key + " and a corresponding value");
        }
        return (String)workContext.get(key);
    }

    public static String getOptionalValueFromRequestParams(WorkContext workContext, String key, String defaultValue) {
        if (workContext.get(key) == null) {
            return defaultValue;
        }
        return (String)workContext.get(key);
    }

    public static enum ProcessType {
        PROJECT,
        USER,
        WORKFLOW_DEFINITION,
        WORKFLOW_TASK_DEFINITION,
        WORKFLOW_EXECUTION,
        WORKFLOW_TASK_EXECUTION,
        WORK;

    }

    public static enum Resource {
        ID,
        NAME,
        PARAMETERS,
        ARGUMENTS,
        STATUS,
        WORKFLOW_OPTIONS(Visibility.PUBLIC),
        PARENT_WORKFLOW,
        ADDITIONAL_INFO;

        private final Visibility visibility;

        private Resource() {
            this.visibility = Visibility.PRIVATE;
        }

        private Resource(Visibility visibility) {
            this.visibility = visibility;
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public boolean isPublic() {
            return Visibility.PUBLIC.equals((Object)this.visibility);
        }
    }
}

