/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.task.shell;

import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflows.work.DefaultWorkReport;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellRunnerTask
extends BaseWorkFlowTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShellRunnerTask.class);
    public static final int DEFAULT_EXECUTION_TIMEOUT_IN_SECONDS = 600;
    Consumer<String> outputConsumer = arg_0 -> ((Logger)log).info(arg_0);

    public WorkReport execute(WorkContext workContext) {
        ShellRunnerTaskParams params = new ShellRunnerTaskParams(workContext);
        ProcessBuilder pb = new ProcessBuilder(params.cmdline);
        File tmpDir = null;
        try {
            boolean elapsed;
            tmpDir = Files.createTempDirectory("parodos-shelltask-runner", PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE))).toFile();
            pb.directory(tmpDir);
            pb.redirectErrorStream(true);
            log.info("begin shell task invocation");
            Process p = pb.start();
            boolean bl = elapsed = !p.waitFor(params.timeoutInSeconds, TimeUnit.SECONDS);
            if (elapsed) {
                DefaultWorkReport defaultWorkReport = new DefaultWorkReport(WorkStatus.FAILED, workContext);
                return defaultWorkReport;
            }
            try (BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                r.lines().forEach(this.outputConsumer);
            }
            log.info("ended shell task invocation");
            DefaultWorkReport defaultWorkReport = new DefaultWorkReport(p.exitValue() == 0 ? WorkStatus.COMPLETED : WorkStatus.FAILED, workContext);
            return defaultWorkReport;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (tmpDir != null) {
                tmpDir.delete();
            }
        }
    }

    private static class ShellRunnerTaskParams {
        ArrayList<String> cmdline;
        int timeoutInSeconds = 600;

        ShellRunnerTaskParams(WorkContext workContext) {
            String command = (String)workContext.get("command");
            if (command == null || command.isBlank()) {
                throw new IllegalArgumentException("argument 'command' is empty or blank");
            }
            this.cmdline = new ArrayList<String>(){};
            this.cmdline.add(command);
            if (workContext.get("args") != null) {
                this.cmdline.addAll(List.of(workContext.get("args").toString().split(" ")));
            }
            if (workContext.get("timeoutInSeconds") != null) {
                this.timeoutInSeconds = Integer.parseInt(workContext.get("timeoutInSeconds").toString());
            }
        }
    }
}

