/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.parodos.workflow.task.checker;

import com.redhat.parodos.workflow.task.BaseWorkFlowTask;
import com.redhat.parodos.workflow.task.WorkFlowTaskType;
import com.redhat.parodos.workflows.engine.WorkFlowEngineBuilder;
import com.redhat.parodos.workflows.work.WorkContext;
import com.redhat.parodos.workflows.work.WorkReport;
import com.redhat.parodos.workflows.work.WorkStatus;
import com.redhat.parodos.workflows.workflow.WorkFlow;
import java.util.Date;

public abstract class BaseWorkFlowCheckerTask
extends BaseWorkFlowTask {
    private WorkFlowTaskType type = WorkFlowTaskType.CHECKER;
    private WorkFlow escalationWorkflow;
    private long expectedCompletionDate;

    public BaseWorkFlowCheckerTask(WorkFlow escalationWorkflow, long expectedSlaBeforeEscalationInSeconds) {
        this.expectedCompletionDate = expectedSlaBeforeEscalationInSeconds;
        this.escalationWorkflow = escalationWorkflow;
    }

    public BaseWorkFlowCheckerTask() {
    }

    protected abstract WorkReport checkWorkFlowStatus(WorkContext var1);

    public WorkReport execute(WorkContext workContext) {
        WorkReport report = this.checkWorkFlowStatus(workContext);
        if (this.escalationWorkflow != null && report.getStatus() == WorkStatus.FAILED && new Date().getTime() > this.expectedCompletionDate) {
            WorkFlowEngineBuilder.aNewWorkFlowEngine().build().run(this.escalationWorkflow, workContext);
        }
        return report;
    }

    public WorkFlowTaskType getType() {
        return this.type;
    }
}

