/*
 * Decompiled with CFR 0.152.
 */
package dev.otbe.gitlab.ci.maven.plugin;

import dev.otbe.gitlab.ci.maven.plugin.BuildMojoKt;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.inject.Inject;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0010"}, d2={"Ldev/otbe/gitlab/ci/maven/plugin/BuildMojo;", "Lorg/apache/maven/plugin/AbstractMojo;", "inputFile", "", "outputFile", "(Ljava/lang/String;Ljava/lang/String;)V", "getInputFile", "()Ljava/lang/String;", "setInputFile", "(Ljava/lang/String;)V", "getOutputFile", "setOutputFile", "execute", "", "getScriptEngine", "Ljavax/script/ScriptEngine;", "gitlab-ci-maven-plugin"})
@Mojo(name="build", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public final class BuildMojo
extends AbstractMojo {
    @Parameter(defaultValue="${inputFile}", required=true)
    @NotNull
    private String inputFile;
    @Parameter(defaultValue="${outputFile}", required=true)
    @NotNull
    private String outputFile;

    @Inject
    public BuildMojo(@NotNull String inputFile, @NotNull String outputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    @NotNull
    public final String getInputFile() {
        return this.inputFile;
    }

    public final void setInputFile(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.inputFile = string;
    }

    @NotNull
    public final String getOutputFile() {
        return this.outputFile;
    }

    public final void setOutputFile(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputFile = string;
    }

    public void execute() {
        BuildMojoKt.access$getLogger$p().info("Using input file: " + this.inputFile);
        BuildMojoKt.access$getLogger$p().info("Using output file: " + this.outputFile);
        Path path = Paths.get(this.inputFile, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IllegalArgumentException("Input file does not exist!");
        }
        ScriptEngine se = this.getScriptEngine();
        Object object = se.eval(new FileReader(this.inputFile));
        if (object == null) {
            throw new IllegalArgumentException("Failed to generate pipe! Check if your last line is similar to pipe.toYaml()");
        }
        Object pipe = object;
        Path path2 = Paths.get(this.outputFile, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
        object = pipe.toString();
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Files.write(path2, byArray, new OpenOption[0]);
    }

    private final ScriptEngine getScriptEngine() {
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByExtension("main.kts");
        Intrinsics.checkNotNull((Object)scriptEngine);
        return scriptEngine;
    }
}

