package dev.otbe.gitlab.ci.dsl

import dev.otbe.gitlab.ci.core.model.Rule
import dev.otbe.gitlab.ci.core.model.Workflow

@GitlabCiDslMarker
class WorkflowBuilder(setup: WorkflowBuilder.() -> Unit = {}) {
    private val rules: MutableList<Rule> = mutableListOf()
    var name: String? = null

    fun rules(init: RulesBuilder.() -> Unit) {
        val builder = RulesBuilder()

        builder.init()

        rules(builder.build())
    }

    fun rules(rule: Rule) {
        this.rules += rule
    }

    fun rules(rules: List<Rule>) {
        this.rules += rules
    }

    fun build(): Workflow {
        if (rules.isEmpty()) {
            throw Exception("workflow must have rules")
        }

        return Workflow(name, rules)
    }
}
