package dev.otbe.gitlab.ci.dsl

@GitlabCiDslMarker
class ScriptItemBuilder : ListItemBuilder<String>() {
    operator fun String.unaryPlus() {
        this@ScriptItemBuilder.items.add(this)
    }

    operator fun List<String>.unaryPlus() {
        this@ScriptItemBuilder.items.addAll(this)
    }
}

object Scripts {
    fun execute(path: String) = listOf(
        "chmod +x $path",
        "./$path",
    )
}
