package dev.otbe.gitlab.ci.dsl

import dev.otbe.gitlab.ci.core.model.Rule

@GitlabCiDslMarker
class RulesBuilder(setup: RulesBuilder.() -> Unit = {}) : ListItemBuilder<Rule>() {
    init {
        setup()
    }

    operator fun Rule.unaryPlus() {
        this@RulesBuilder.items.add(this)
    }

    operator fun List<Rule>.unaryPlus() {
        this@RulesBuilder.items.addAll(this)
    }

    fun rule(init: RuleBuilder.() -> Unit): Rule {
        val builder = RuleBuilder()

        builder.init()

        return builder.build()
    }

    override fun build(): List<Rule> {
        return items
    }
}

object Rules {
    val ONLY_ON_MERGE_REQUESTS = RuleBuilder {
        `if` = "\$CI_PIPELINE_SOURCE == \"merge_request_event\""
    }.build()

    val EXCLUDE_ON_SCHEDULE = RulesBuilder {
        +rule {
            `if` = "\$CI_PIPELINE_SOURCE == \"schedule\""
            `when` = Rule.When.NEVER
        }

        +rule {
            `when` = Rule.When.ALWAYS
        }
    }.build()
}

@GitlabCiDslMarker
class RuleBuilder(setup: RuleBuilder.() -> Unit = {}) {
    var `if`: String? = null
    private var changes: Rule.Change? = null
    var exists: List<String> = emptyList()
    var allowFailure: Boolean? = null
    var variables: Map<String, String> = mutableMapOf()
    var `when`: Rule.When? = null

    init {
        setup()
    }

    fun changes(init: ChangeBuilder.() -> Unit) {
        val builder = ChangeBuilder()

        builder.init()

        changes = builder.build()
    }

    fun variables(vararg entries: Pair<String, String>) {
        variables = variables.plus(entries.asList())
    }

    fun build(): Rule {
        return Rule(`if`, changes, exists, allowFailure, variables, `when`)
    }
}

@GitlabCiDslMarker
class ChangeBuilder : Builder<Rule.Change> {
    lateinit var paths: List<String>
    var compareTo: List<String> = emptyList()

    override fun build(): Rule.Change {
        if (!this::paths.isInitialized) {
            throw Exception("every job needs a stage")
        }

        return Rule.Change(paths, compareTo)
    }
}
