package dev.otbe.gitlab.ci.dsl

import dev.otbe.gitlab.ci.core.model.*
import dev.otbe.gitlab.ci.core.toYml
import java.nio.file.Files
import java.nio.file.Path

@GitlabCiDslMarker
class PipelineBuilder {
    private val includes: MutableList<Include> = mutableListOf()
    private val jobs: MutableList<Job> = mutableListOf()
    private val stages: MutableList<Stage> = mutableListOf()
    private var workflow: Workflow? = null

    fun include(include: Include) {
        includes += include
    }

    fun workflow(init: WorkflowBuilder.() -> Unit) {
        val builder = WorkflowBuilder()

        builder.init()

        workflow = builder.build()
    }

    fun job(job: Job) {
        jobs += job
    }

    fun job(name: String, init: JobBuilder.() -> Unit = {}): Job {
        val jobBuilder = JobBuilder(name)

        jobBuilder.init()

        val job = jobBuilder.build()

        jobs += job

        return job
    }

    fun stages(init: StagesItemBuilder.() -> Unit) {
        val builder = StagesItemBuilder()

        builder.init()

        stages += builder.build()
    }

    fun build() = Pipeline(
        includes,
        workflow,
        null,
        if (stages.isEmpty()) jobs.map { it.stage }.distinct() else stages,
        jobs,
    )
}

fun pipeline(init: PipelineBuilder.() -> Unit): Pipeline {
    val pipe = PipelineBuilder()

    pipe.init()

    return pipe.build()
}

infix fun Pipeline.to(target: Path) {
    Files.write(target, toYml().lines())
}
