package dev.otbe.gitlab.ci.dsl

import dev.otbe.gitlab.ci.core.model.*
import kotlin.time.Duration

@GitlabCiDslMarker
class JobBuilder(private val name: String, setup: JobBuilder.() -> Unit = {}) {
    lateinit var stage: Stage
    var image: Image? = null
    var variables: Map<String, String>? = emptyMap()
    var interruptible: Boolean? = false
    var resourceGroup: ResourceGroup? = null
    var timeout: Duration? = null

    private var artifacts: Artifacts? = null
    private val needs: MutableList<Job> = mutableListOf()
    private val scripts: MutableList<String> = mutableListOf()
    private val rules: MutableList<Rule> = mutableListOf()
    private val tags: MutableList<Tag> = mutableListOf()

    private var cache: Cache? = null

    init {
        setup()
    }

    fun artifacts(init: ArtifactsBuilder.() -> Unit = {}): Artifacts {
        val builder = ArtifactsBuilder()

        builder.init()

        artifacts = builder.build()

        return artifacts!!
    }

    // maybe remove this
    fun needs(init: NeedsItemBuilder.() -> Unit) {
        val builder = NeedsItemBuilder()

        builder.init()

        needs += builder.build()
    }

    fun needs(vararg job: Job) {
        needs += job.asList()
    }

    fun scripts(init: ScriptItemBuilder.() -> Unit) {
        val builder = ScriptItemBuilder()

        builder.init()

        scripts += builder.build()
    }

    fun cache(cache: Cache) {
        this.cache = cache
    }

    fun cache(init: CacheBuilder.() -> Unit): Cache {
        val cacheBuilder = CacheBuilder()

        cacheBuilder.init()

        cache = cacheBuilder.build()

        return cache!!
    }

    fun rules(init: RulesBuilder.() -> Unit) {
        val builder = RulesBuilder()

        builder.init()

        rules(builder.build())
    }

    fun rules(rule: Rule) {
        this.rules += rule
    }

    fun rules(rules: List<Rule>) {
        this.rules += rules
    }

    fun tags(vararg tag: Tag) {
        tags += tag.asList()
    }

    fun build(): Job {
        if (!this::stage.isInitialized) {
            throw Exception("every job needs a stage")
        }

        if (scripts.isEmpty()) {
            throw Exception("$name does not have a script section")
        }

        return Job(
            name,
            stage,
            image,
            variables,
            needs.map { it.name },
            artifacts,
            rules,
            scripts,
            cache,
            interruptible,
            timeout,
            resourceGroup,
            tags,
        )
    }
}
