package dev.otbe.gitlab.ci.dsl

import dev.otbe.gitlab.ci.core.model.Cache

@GitlabCiDslMarker
class CacheBuilder(setup: CacheBuilder.() -> Unit = {}) : Builder<Cache> {
    private val paths: MutableList<String> = mutableListOf()

    var `when`: Cache.When? = null

    var untracked: Boolean? = null

    var policy: Cache.Policy? = null

    init {
        setup()
    }

    fun paths(init: PathsBuilder.() -> Unit) {
        val builder = PathsBuilder()

        builder.init()

        paths += builder.build()
    }

    override fun build(): Cache {
        return Cache(paths, null, untracked, `when`, policy)
    }
}
