package dev.otbe.gitlab.ci.dsl

import dev.otbe.gitlab.ci.core.model.Artifacts

@GitlabCiDslMarker
class ArtifactsBuilder : Builder<Artifacts> {
    private var paths: List<String> = mutableListOf()

    fun paths(init: PathsBuilder.() -> Unit) {
        val builder = PathsBuilder()

        builder.init()

        paths += builder.build()
    }

    override fun build(): Artifacts {
        if (paths.isEmpty()) {
            throw Exception("")
        }

        return Artifacts(paths)
    }
}
