package dev.otbe.gitlab.ci.core.model

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class Cache(
    val paths: List<Path> = emptyList(),
    val key: String? = null,
    val untracked: Boolean? = false,
    val `when`: When? = When.ON_SUCCESS,
    val policy: Policy? = Policy.PULL_PUSH,
) {

    enum class Policy {
        @SerialName("pull")
        PULL,

        @SerialName("push")
        PUSH,

        @SerialName("pull-push")
        PULL_PUSH,
    }
}
