package dev.otbe.gitlab.ci.constructs.pipelines

import dev.otbe.gitlab.ci.dsl.PipelineBuilder
import dev.otbe.gitlab.ci.dsl.rules.RulesBuilder

object DefaultPipeline {
    fun defaultPipeline(setup: PipelineBuilder.() -> Unit) =
        PipelineBuilder {
            workflow(masterAndMr)
        }.also(setup).build()

    val masterAndMr = RulesBuilder {
        +rule {
            `if` = "\$CI_PIPELINE_SOURCE == \"merge_request_event\""
        }
        +rule {
            `if` = "\$CI_COMMIT_BRANCH == \$CI_DEFAULT_BRANCH"
        }
    }.build()
}
