package dev.otbe.gitlab.ci.constructs.mvn

import dev.otbe.gitlab.ci.core.model.Cache
import dev.otbe.gitlab.ci.core.model.Image
import dev.otbe.gitlab.ci.core.model.Stage
import dev.otbe.gitlab.ci.dsl.cache.CacheBuilder
import dev.otbe.gitlab.ci.dsl.jobs.JobBuilder

object MvnJob {
    fun mvnJob(name: String, cmd: String, _stage: Stage = Stage(name), setup: JobBuilder.() -> Unit = {}) =
        JobBuilder(name) {
            stage = _stage
            image = Image.of("maven:3.9.1-eclipse-temurin-17")

            cache(pullPushCache)

            script(mvn(cmd))
        }.also(setup).build()

    fun mvnwJob(name: String, cmd: String, _stage: Stage = Stage(name), setup: JobBuilder.() -> Unit = {}) =
        JobBuilder(name) {
            stage = _stage
            image = Image.of("eclipse-temurin:17.0.7_7-jdk")

            cache(pullPushCache)

            script(mvnw(cmd))
        }.also(setup).build()

    val pullPushCache = CacheBuilder {
        policy = Cache.Policy.PULL_PUSH
        paths {
            +".m2/"
        }
    }.build()

    fun mvnw(command: String): String {
        return "./mvnw -Dmaven.repo.local=.m2/repository --batch-mode $command"
    }

    fun mvn(command: String): String {
        return "mvn -Dmaven.repo.local=.m2/repository --batch-mode $command"
    }
}
