package dev.openmobile.ui.utils

import android.util.Log
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import dev.openmobile.ui.components.inputs.UIButton
import dev.openmobile.ui.components.inputs.UIImage
import dev.openmobile.ui.components.inputs.UIText
import dev.openmobile.ui.components.layouts.UIColumn
import dev.openmobile.ui.components.layouts.UIRow
import dev.openmobile.ui.components.layouts.UIWebView

@Composable
fun UIParser(json: Map<*, *>) {
    Log.d("UIParser", "json: ${json["type"]}")
    val type = json["type"] ?: throw Exception("Missing type attribute")
    return when (type) {
        "column" -> UIColumn(json = json)
        "row" -> UIRow(json = json)
        "text" -> UIText(json = json)
        "image" -> UIImage(json = json)
        "button" -> UIButton(json = json)
        "webView" -> UIWebView(json = json)
        else -> Text(text = "Component $type Not Found")
    }
}
