package dev.openmobile.ui.components.layouts

import android.util.Log
import android.view.ViewGroup
import android.webkit.JavascriptInterface
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.viewinterop.AndroidView
import dev.openmobile.core.OpenMobileCore
import dev.openmobile.ui.utils.parseFromJson
import org.json.JSONObject

@Composable
fun UIWebView(json: Map<*, *>) {
    val attributes = json["attributes"] as Map<*, *>?
    val modifier = Modifier.parseFromJson(attributes?.get("modifier") as Map<*, *>?)
    val url = attributes?.get("url") as String? ?: ""

    AndroidView(factory = {
        WebView(it).apply {
            layoutParams = ViewGroup.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT
            )
            webViewClient = WebViewClient()
            settings.javaScriptEnabled = true
            settings.domStorageEnabled = true
            addJavascriptInterface(AttributesJSBridge(), "AttributesJSBridge")
            loadUrl(url)
        }
    }, update = {
        it.loadUrl(url)
    }, modifier = modifier)
}

class AttributesJSBridge {
    @JavascriptInterface
    fun setAttributes(jsonAttributes: String?) {
        jsonAttributes?.let {
            try {
                val data = JSONObject(jsonAttributes)
                data.keys().forEach {
                    Log.d("Openmobile", "SetSettingsValue key: $it value: ${data[it]}")
                    OpenMobileCore.setSettingsValue(it, data[it].toString())
                }
            } catch (ex: Exception) {
                Log.d("Openmobile", ex.message ?: "Error parsing")
            }
        } ?: run {
            Log.d("Openmobile", "attributes is empty or null")
        }
    }
}
