package dev.openmobile.ui.components.layouts

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import dev.openmobile.ui.utils.UIParser
import dev.openmobile.ui.utils.horizontalArrangementFromJson
import dev.openmobile.ui.utils.parseFromJson
import dev.openmobile.ui.utils.verticalAlignmentFromJson

@Composable
fun UIRow(json: Map<*, *>) {
    val children = json["children"] as List<*>?
    val attributes = json["attributes"] as Map<*, *>?
    val modifier = Modifier.parseFromJson(attributes?.get("modifier") as Map<*, *>?)
    val verticalAlignment = attributes?.get("verticalAlignment") as String? ?: ""
    val horizontalArrangement = attributes?.get("horizontalArrangement") as String? ?: ""

    return Row(
        horizontalArrangement = Arrangement.horizontalArrangementFromJson(horizontalArrangement),
        verticalAlignment = Alignment.verticalAlignmentFromJson(verticalAlignment),
        modifier = modifier,
    ) {
        children?.map {
            UIParser(json = it as Map<*, *>)
        }
    }
}
