package dev.openmobile.ui.components.layouts

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import dev.openmobile.ui.utils.*

@Composable
fun UIColumn(json: Map<*, *>) {
    val children = json["children"] as List<*>?
    val attributes = json["attributes"] as Map<*, *>?
    val modifier = Modifier.parseFromJson(attributes?.get("modifier") as Map<*, *>?)
    val verticalArrangement = attributes?.get("verticalArrangement") as String? ?: ""
    val horizontalAlignment = attributes?.get("horizontalAlignment") as String? ?: ""

    return Column(
        modifier = modifier,
        verticalArrangement = Arrangement.verticalArrangementFromJson(verticalArrangement),
        horizontalAlignment = Alignment.horizontalAlignmentFromJson(horizontalAlignment),
    ) {
        children?.map {
            UIParser(json = it as Map<*, *>)
        }
    }
}
