package dev.openmobile.ui.components.inputs

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import coil.compose.AsyncImage
import dev.openmobile.ui.utils.fromString
import dev.openmobile.ui.utils.parseFromJson

@Composable
fun UIImage(json: Map<*, *>) {
    val attributes = json["attributes"] as Map<*, *>
    val url = attributes["url"] as String? ?: "https://via.placeholder.com/150"
    val contentScale = attributes["contentScale"] as String? ?: ""
    val contentDescription = attributes["contentDescription"] as String? ?: ""
    val modifier = Modifier.parseFromJson(attributes["modifier"] as Map<*, *>?)
    return AsyncImage(
        model = url,
        modifier = modifier,
        contentDescription = contentDescription,
        contentScale = ContentScale.fromString(contentScale),
    )
}
