package dev.openmobile.ui.components.inputs

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Button
import androidx.compose.material.ButtonDefaults
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import androidx.core.graphics.toColorInt
import dev.openmobile.ui.UIManager.runActionByMap
import dev.openmobile.ui.utils.UIParser
import dev.openmobile.ui.utils.parseFromJson
import dev.openmobile.ui.utils.parseToDouble

@Composable
fun UIButton(json: Map<*, *>) {
    /* Todo: missing attributes to mapping
    enabled: Boolean = true,
    interactionSource: MutableInteractionSource = remember { MutableInteractionSource() },
    elevation: ButtonElevation? = ButtonDefaults.elevation(),
    shape: Shape = MaterialTheme.shapes.small,
    */
    val attributes = json["attributes"] as Map<*, *>
    val child = json["child"] as Map<*, *>
    val color = Color((attributes["color"] as String?)?.toColorInt() ?: Color.Black.hashCode())
    val rounded = attributes["rounded"].parseToDouble(0.0)!!
    val borderColor = Color((attributes["borderColor"] as String?)?.toColorInt() ?: Color.Transparent.hashCode())
    val borderWidth = attributes["borderWidth"].parseToDouble(0.0)!!
    val modifier = Modifier.parseFromJson(attributes["modifier"] as Map<*, *>?)
    val action = json["action"] as Map<*, *>?
    return Button(
        onClick = runAction(action),
        shape = RoundedCornerShape(rounded.toFloat()),
        colors = ButtonDefaults.buttonColors(backgroundColor = color),
        border = BorderStroke(borderWidth.dp, borderColor),
        modifier = modifier
    ) {
        UIParser(json = child)
    }
}

fun runAction(attributes: Map<*, *>?): () -> Unit = {
    runActionByMap(attributes)
}
