package dev.openmobile.ui

import android.annotation.SuppressLint
import android.content.Context
import android.util.Log
import dev.openmobile.core.OpenMobileCore
import dev.openmobile.core.actions.OpenMobileActions

object UIManager {
    @SuppressLint("StaticFieldLeak")
    lateinit var client: ClientManager

    fun initialize(context: Context): ClientManager {
        client = ClientManager(context)
        return client
    }

    fun runActionByMap(action: Map<*, *>?) {
        action?.let {
            val type = action["type"] as String? ?: "UI_OPEN_URL"
            val parameters = action["parameters"] as Map<*, *>?
            Log.d("open", "click $parameters")
            OpenMobileActions.getActionLink(type, parameters)?.let {
                OpenMobileCore.runAction(it)
            } ?: run {
                Log.i(
                    "OpenMobile ",
                    "runAction couldn't find the actionLink from type :: $type and params: $parameters"
                )
            }
        }
    }

}
