package dev.openmobile.ui

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Bundle
import android.util.Log
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import dev.openmobile.ui.utils.UIParser
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject


class LayoutActivity : ComponentActivity() {
    companion object {
        const val LAYOUT_ACTIVITY_JSON_PARAM = "LAYOUT_ACTIVITY_JSON_PARAM"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val filter = IntentFilter()
        filter.addAction("dev.openmobile.ui.FINISH_ACTIVITY")
        registerReceiver(receiver, filter)
        val json = intent.extras?.getString(LAYOUT_ACTIVITY_JSON_PARAM)
        setContent {
            Surface(
                modifier = Modifier.fillMaxSize(),
                color = MaterialTheme.colors.background
            ) {
                Layout(json)
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        unregisterReceiver(receiver)
    }

    private val receiver: BroadcastReceiver = object : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent) {
            finish()
        }
    }
}

@Composable
fun Layout(jsonString: String?) {
    jsonString?.let {
        val data = JSONObject(jsonString)
        val map = data.toMap()
        Log.d("OpenMobileUI", "component -> ${map["type"]}")
        UIParser(json = map)
    } ?: run {
        Text(text = "Json not found")
    }
}

@Throws(JSONException::class)
fun JSONObject.toMap(): Map<String, Any> {
    val map = mutableMapOf<String, Any>()
    val keysItr: Iterator<String> = this.keys()
    while (keysItr.hasNext()) {
        val key = keysItr.next()
        var value: Any = this.get(key)
        when (value) {
            is JSONArray -> value = value.toList()
            is JSONObject -> value = value.toMap()
        }
        map[key] = value
    }
    return map
}

@Throws(JSONException::class)
fun JSONArray.toList(): List<Any> {
    val list = mutableListOf<Any>()
    for (i in 0 until this.length()) {
        var value: Any = this[i]
        when (value) {
            is JSONArray -> value = value.toList()
            is JSONObject -> value = value.toMap()
        }
        list.add(value)
    }
    return list
}

@Preview
@Composable
fun DefaultPreview() {
}
