package dev.openmobile.ui

import android.os.Bundle
import android.util.Log
import androidx.activity.ComponentActivity
import dev.openmobile.core.OpenMobileCore
import dev.openmobile.core.actions.OpenMobileActions
import org.json.JSONObject


class ActionIntentActivity : ComponentActivity() {
    companion object {
        const val INTENT_ACTIVITY_ACTION = "INTENT_ACTIVITY_ACTION"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val action = intent.extras?.getString(INTENT_ACTIVITY_ACTION)
        action?.let {
            val actionMap = JSONObject(action).toMap()
            Log.i("OpenMobile ", "actionMap :: $actionMap")
            actionMap["type"]?.let { type ->
                OpenMobileActions.getActionLink(
                    type as String, actionMap["parameters"] as Map<*, *>
                )?.let {
                    OpenMobileCore.runAction(it)
                }
            }
        }
        finish()
    }
}
