package dev.openmobile.ui.utils

import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import dev.openmobile.ui.components.inputs.UIButton
import dev.openmobile.ui.components.inputs.UIImage
import dev.openmobile.ui.components.inputs.UIText
import dev.openmobile.ui.components.layouts.UIColumn
import dev.openmobile.ui.components.layouts.UIRow

@Composable
fun UIParser(json: Map<*, *>) {
    val type = json["type"] ?: throw Exception("Missing type attribute")
    return when (type) {
        "column" -> UIColumn(json = json)
        "row" -> UIRow(json = json)
        "text" -> UIText(json = json)
        "image" -> UIImage(json = json)
        "button" -> UIButton(json = json)
        else -> Text(text = "Not Found")
    }
}
